/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.openai;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.openai.OpenAiActionVisitor;
import org.elasticsearch.xpack.inference.external.action.openai.OpenAiEmbeddingsAction;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsModel;

public class OpenAiActionCreator
implements OpenAiActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public OpenAiActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(OpenAiEmbeddingsModel model, Map<String, Object> taskSettings) {
        OpenAiEmbeddingsModel overriddenModel = model.overrideWith(taskSettings);
        return new OpenAiEmbeddingsAction(this.sender, overriddenModel, this.serviceComponents);
    }
}

