/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.rate;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.rate.InternalResetTrackingRate;
import org.elasticsearch.xpack.analytics.rate.RateMode;

public final class TimeSeriesRateAggregator
extends NumericMetricsAggregator.SingleValue {
    private final ValuesSource.Numeric valuesSource;
    private DoubleArray startValues;
    private DoubleArray endValues;
    private LongArray startTimes;
    private LongArray endTimes;
    private DoubleArray resetCompensations;
    private long currentBucket = -1L;
    private long currentEndTime = -1L;
    private long currentStartTime = -1L;
    private double resetCompensation = 0.0;
    private double currentEndValue = -1.0;
    private double currentStartValue = -1.0;
    private int currentTsid = -1;
    private final Rounding.DateTimeUnit rateUnit;

    TimeSeriesRateAggregator(String name, ValuesSourceConfig valuesSourceConfig, Rounding.DateTimeUnit rateUnit, RateMode rateMode, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = (ValuesSource.Numeric)valuesSourceConfig.getValuesSource();
        this.startValues = this.bigArrays().newDoubleArray(1L, true);
        this.endValues = this.bigArrays().newDoubleArray(1L, true);
        this.startTimes = this.bigArrays().newLongArray(1L, true);
        this.endTimes = this.bigArrays().newLongArray(1L, true);
        this.resetCompensations = this.bigArrays().newDoubleArray(1L, true);
        this.rateUnit = rateUnit;
        for (Aggregator parentIterator = parent; parentIterator != null; parentIterator = parentIterator.parent()) {
            if (!(parentIterator instanceof DeferableBucketAggregator)) continue;
            throw new IllegalArgumentException("Wrapping a time-series rate aggregation within a DeferableBucketAggregator is not supported. Consider using an alternative outer aggregation type to avoid this, e.g. date_histogram instead of auto_date_histogram.");
        }
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalResetTrackingRate(this.name, DocValueFormat.RAW, this.metadata(), 0.0, 0.0, 0L, 0L, 0.0, Rounding.DateTimeUnit.SECOND_OF_MINUTE);
    }

    private void calculateLastBucket() {
        if (this.currentBucket != -1L) {
            this.startValues.set(this.currentBucket, this.currentStartValue);
            this.endValues.set(this.currentBucket, this.currentEndValue);
            this.startTimes.set(this.currentBucket, this.currentStartTime);
            this.endTimes.set(this.currentBucket, this.currentEndTime);
            this.resetCompensations.set(this.currentBucket, this.resetCompensation);
            this.currentBucket = -1L;
        }
    }

    private double checkForResets(double latestValue) {
        if (latestValue > this.currentStartValue) {
            this.resetCompensation += this.currentEndValue;
            this.currentEndValue = latestValue;
        }
        return latestValue;
    }

    protected LeafBucketCollector getLeafCollector(final AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final NumericDoubleValues leafValues = MultiValueMode.MAX.select(this.valuesSource.doubleValues(aggCtx.getLeafReaderContext()));
        return new LeafBucketCollectorBase(sub, null){

            public void collect(int doc, long bucket) throws IOException {
                leafValues.advanceExact(doc);
                double latestValue = leafValues.doubleValue();
                if (bucket != TimeSeriesRateAggregator.this.currentBucket) {
                    TimeSeriesRateAggregator.this.startValues = TimeSeriesRateAggregator.this.bigArrays().grow(TimeSeriesRateAggregator.this.startValues, bucket + 1L);
                    TimeSeriesRateAggregator.this.endValues = TimeSeriesRateAggregator.this.bigArrays().grow(TimeSeriesRateAggregator.this.endValues, bucket + 1L);
                    TimeSeriesRateAggregator.this.startTimes = TimeSeriesRateAggregator.this.bigArrays().grow(TimeSeriesRateAggregator.this.startTimes, bucket + 1L);
                    TimeSeriesRateAggregator.this.endTimes = TimeSeriesRateAggregator.this.bigArrays().grow(TimeSeriesRateAggregator.this.endTimes, bucket + 1L);
                    TimeSeriesRateAggregator.this.resetCompensations = TimeSeriesRateAggregator.this.bigArrays().grow(TimeSeriesRateAggregator.this.resetCompensations, bucket + 1L);
                    if (TimeSeriesRateAggregator.this.currentTsid != aggCtx.getTsidOrd()) {
                        TimeSeriesRateAggregator.this.calculateLastBucket();
                        TimeSeriesRateAggregator.this.currentTsid = aggCtx.getTsidOrd();
                    } else {
                        TimeSeriesRateAggregator.this.currentStartTime = aggCtx.getTimestamp();
                        TimeSeriesRateAggregator.this.currentStartValue = TimeSeriesRateAggregator.this.checkForResets(latestValue);
                        TimeSeriesRateAggregator.this.calculateLastBucket();
                    }
                    TimeSeriesRateAggregator.this.currentBucket = bucket;
                    TimeSeriesRateAggregator.this.currentStartTime = TimeSeriesRateAggregator.this.currentEndTime = aggCtx.getTimestamp();
                    TimeSeriesRateAggregator.this.currentStartValue = TimeSeriesRateAggregator.this.currentEndValue = latestValue;
                    TimeSeriesRateAggregator.this.resetCompensation = 0.0;
                } else {
                    TimeSeriesRateAggregator.this.currentStartTime = aggCtx.getTimestamp();
                    TimeSeriesRateAggregator.this.currentStartValue = TimeSeriesRateAggregator.this.checkForResets(latestValue);
                }
            }
        };
    }

    public InternalResetTrackingRate buildAggregation(long owningBucketOrd) {
        this.calculateLastBucket();
        return new InternalResetTrackingRate(this.name, DocValueFormat.RAW, this.metadata(), this.startValues.get(owningBucketOrd), this.endValues.get(owningBucketOrd), this.startTimes.get(owningBucketOrd), this.endTimes.get(owningBucketOrd), this.resetCompensations.get(owningBucketOrd), this.rateUnit == null ? Rounding.DateTimeUnit.SECOND_OF_MINUTE : this.rateUnit);
    }

    protected void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.startValues, this.endValues, this.startTimes, this.endTimes, this.resetCompensations});
    }

    public double metric(long owningBucketOrd) {
        return this.buildAggregation(owningBucketOrd).getValue();
    }
}

