/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.common.settings.Settings;

public interface Migration {
    public int getTargetIndexTemplateVersion();

    public void apply(String var1, Consumer<PutMappingRequest> var2, Consumer<UpdateSettingsRequest> var3);

    public static class DynamicIndexSettingsMigration
    implements Migration {
        private final int targetVersion;
        private final Settings settings;

        public DynamicIndexSettingsMigration(int targetVersion, Settings settings) {
            this.targetVersion = targetVersion;
            this.settings = settings;
        }

        @Override
        public int getTargetIndexTemplateVersion() {
            return this.targetVersion;
        }

        @Override
        public void apply(String index, Consumer<PutMappingRequest> mappingConsumer, Consumer<UpdateSettingsRequest> settingsConsumer) {
            settingsConsumer.accept(new UpdateSettingsRequest(this.settings, new String[]{index}));
        }

        public String toString() {
            return String.format(Locale.ROOT, "update settings to target version [%d]", this.targetVersion);
        }
    }

    public static class PutMappingMigration
    implements Migration {
        private final int targetVersion;
        private final Map<String, ?> body;

        public PutMappingMigration(int targetVersion, Map<String, ?> body) {
            this.targetVersion = targetVersion;
            this.body = body;
        }

        @Override
        public int getTargetIndexTemplateVersion() {
            return this.targetVersion;
        }

        @Override
        public void apply(String index, Consumer<PutMappingRequest> mappingConsumer, Consumer<UpdateSettingsRequest> settingsConsumer) {
            mappingConsumer.accept(new PutMappingRequest(new String[]{index}).source(this.body));
        }

        public String toString() {
            return String.format(Locale.ROOT, "put mapping to target version [%d]", this.targetVersion);
        }
    }

    public static class Builder {
        private final List<Migration> migrations = new ArrayList<Migration>();
        private Integer targetVersion;

        private void checkVersionSet() {
            if (this.targetVersion == null) {
                throw new IllegalStateException("Set targetVersion before defining migrations");
            }
        }

        public Builder migrateToIndexTemplateVersion(int version) {
            this.targetVersion = version;
            return this;
        }

        public Builder addProperty(String property, String type) {
            Map<String, Map<String, Map<String, String>>> body = Map.of("properties", Map.of(property, Map.of("type", type)));
            return this.putMapping(body);
        }

        public Builder putMapping(Map<String, ?> body) {
            this.checkVersionSet();
            this.migrations.add(new PutMappingMigration(this.targetVersion, body));
            return this;
        }

        public Builder dynamicSettings(Settings settings) {
            this.checkVersionSet();
            this.migrations.add(new DynamicIndexSettingsMigration(this.targetVersion, settings));
            return this;
        }

        public List<Migration> build(int indexVersion) {
            Map<String, Map<String, Integer>> updateIndexTemplateVersion = Map.of("_meta", Map.of("index-template-version", this.targetVersion, "index-version", indexVersion));
            this.migrations.add(new PutMappingMigration(this.targetVersion, updateIndexTemplateVersion));
            return Collections.unmodifiableList(this.migrations);
        }
    }
}

