/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.profiling.CostEntry;
import org.elasticsearch.xpack.profiling.InstanceType;

public final class InstanceTypeService {
    private InstanceTypeService() {
    }

    public static CostEntry getCosts(InstanceType instance) {
        return Holder.costsPerDatacenter.get(instance);
    }

    private static final class Holder {
        private static final Map<InstanceType, CostEntry> costsPerDatacenter;

        private Holder() {
        }

        static {
            HashMap objects = new HashMap();
            Function<String, String> dedupString = s -> (String)objects.computeIfAbsent((CostEntry)s, Function.identity());
            HashMap<InstanceType, CostEntry> tmp = new HashMap<InstanceType, CostEntry>();
            try (GZIPInputStream in = new GZIPInputStream(InstanceTypeService.class.getClassLoader().getResourceAsStream("profiling-costs.json.gz"));
                 XContentParser parser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY, (InputStream)in);){
                if (parser.currentToken() == null) {
                    parser.nextToken();
                }
                List rawData = XContentParserUtils.parseList((XContentParser)parser, XContentParser::map);
                for (Map entry : rawData) {
                    tmp.put(new InstanceType(dedupString.apply((String)entry.get("provider")), dedupString.apply((String)entry.get("region")), dedupString.apply((String)entry.get("instance_type"))), (CostEntry)objects.computeIfAbsent(CostEntry.fromSource(entry), Function.identity()));
                }
                costsPerDatacenter = Map.copyOf(tmp);
            }
            catch (IOException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

