/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

final class CostEntry
implements ToXContentObject {
    final double co2Factor;
    final double costFactor;

    CostEntry(double co2Factor, double costFactor) {
        this.co2Factor = co2Factor;
        this.costFactor = costFactor;
    }

    public static CostEntry fromSource(Map<String, Object> source) {
        return new CostEntry((Double)source.get("co2_factor"), (Double)source.get("cost_factor"));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("co2_factor", this.co2Factor);
        builder.field("cost_factor", this.costFactor);
        builder.endObject();
        return builder;
    }
}

