/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling;

import java.util.Map;

final class CloudProviders {
    private static final Map<String, Provider> PROVIDERS = Map.of("aws", new Provider(1.135, Map.ofEntries(Map.entry("us-east-1", 3.79069E-4), Map.entry("us-east-2", 4.10608E-4), Map.entry("us-west-1", 3.22167E-4), Map.entry("us-west-2", 3.22167E-4), Map.entry("us-gov-east-1", 3.79069E-4), Map.entry("us-gov-west-1", 3.22167E-4), Map.entry("af-south-1", 9.006E-4), Map.entry("ap-east-1", 7.1E-4), Map.entry("ap-south-1", 7.082E-4), Map.entry("ap-northeast-3", 4.658E-4), Map.entry("ap-northeast-2", 4.156E-4), Map.entry("ap-southeast-1", 4.08E-4), Map.entry("ap-southeast-2", 7.6E-4), Map.entry("ap-southeast-3", 7.177E-4), Map.entry("ap-northeast-1", 4.658E-4), Map.entry("ca-central-1", 1.2E-4), Map.entry("cn-north-1", 5.374E-4), Map.entry("cn-northwest-1", 5.374E-4), Map.entry("eu-central-1", 3.11E-4), Map.entry("eu-west-1", 2.786E-4), Map.entry("eu-west-2", 2.25E-4), Map.entry("eu-south-1", 2.134E-4), Map.entry("eu-west-3", 5.11E-5), Map.entry("eu-north-1", 8.8E-6), Map.entry("me-south-1", 5.059E-4), Map.entry("me-central-1", 4.041E-4), Map.entry("sa-east-1", 6.17E-5))), "gcp", new Provider(1.1, Map.ofEntries(Map.entry("us-central1", 2.152373529E-4), Map.entry("us-central2", 2.152373529E-4), Map.entry("us-east1", 3.255E-4), Map.entry("us-east4", 1.1124E-4), Map.entry("us-east5", 1.1124E-4), Map.entry("us-west1", 7.2E-6), Map.entry("us-west2", 8.93E-5), Map.entry("us-west3", 3.0912E-4), Map.entry("us-west4", 2.8835E-4), Map.entry("us-south1", 1.776E-4), Map.entry("asia-east1", 3.7848E-4), Map.entry("asia-east2", 2.592E-4), Map.entry("asia-northeast1", 3.8976E-4), Map.entry("asia-northeast2", 2.6496E-4), Map.entry("asia-northeast3", 2.9325E-4), Map.entry("asia-south1", 6.03E-4), Map.entry("asia-south2", 6.1732E-4), Map.entry("asia-southeast1", 3.5712E-4), Map.entry("asia-southeast2", 5.046E-4), Map.entry("australia-southeast1", 4.7242E-4), Map.entry("australia-southeast2", 3.5949E-4), Map.entry("europe-central2", 4.608E-4), Map.entry("europe-north1", 1.143E-5), Map.entry("europe-southwest1", 1.21E-4), Map.entry("europe-west1", 1.98E-5), Map.entry("europe-west2", 7.396E-5), Map.entry("europe-west3", 1.076E-4), Map.entry("europe-west4", 1.3301E-4), Map.entry("europe-west6", 1.29E-5), Map.entry("europe-west8", 2.98E-4), Map.entry("europe-west9", 5.9E-5), Map.entry("northamerica-northeast1", 0.0), Map.entry("northamerica-northeast2", 2.32E-6), Map.entry("southamerica-east1", 2.838E-5), Map.entry("southamerica-west1", 5.89E-5))), "azure", new Provider(1.185, Map.ofEntries(Map.entry("centralus", 4.26254E-4), Map.entry("centraluseuap", 4.26254E-4), Map.entry("centralusestage", 4.26254E-4), Map.entry("eastus", 3.79069E-4), Map.entry("useast", 3.79069E-4), Map.entry("eastusstage", 3.79069E-4), Map.entry("eastus2", 3.79069E-4), Map.entry("useast2", 3.79069E-4), Map.entry("eastus2euap", 3.79069E-4), Map.entry("eastus2stage", 3.79069E-4), Map.entry("eastus3", 3.79069E-4), Map.entry("usnorth", 4.10608E-4), Map.entry("northcentralus", 4.10608E-4), Map.entry("northcentralusstage", 4.10608E-4), Map.entry("southcentralus", 3.73231E-4), Map.entry("southcentralusstage", 3.73231E-4), Map.entry("unitedstates", 3.73231E-4), Map.entry("unitedstateseuap", 3.73231E-4), Map.entry("westcentralus", 3.22167E-4), Map.entry("westcentralusstage", 3.22167E-4), Map.entry("westus", 3.22167E-4), Map.entry("westusstage", 3.22167E-4), Map.entry("westus2", 3.22167E-4), Map.entry("westus2stage", 3.22167E-4), Map.entry("westus3", 3.22167E-4), Map.entry("asia", 5.647E-4), Map.entry("asiapacific", 5.647E-4), Map.entry("eastasia", 7.1E-4), Map.entry("eastasiastage", 7.1E-4), Map.entry("southeastasia", 4.08E-4), Map.entry("asiasoutheast", 4.08E-4), Map.entry("southafricanorth", 9.006E-4), Map.entry("southafricawest", 9.006E-4), Map.entry("southafrica", 9.006E-4), Map.entry("australia", 7.9E-4), Map.entry("australiacentral", 7.9E-4), Map.entry("australiacentral2", 7.9E-4), Map.entry("australiaeast", 7.9E-4), Map.entry("australiasoutheast", 9.6E-4), Map.entry("apeast", 7.1E-4), Map.entry("apsoutheast", 4.08E-4), Map.entry("japan", 4.658E-4), Map.entry("japanwest", 4.658E-4), Map.entry("japaneast", 4.658E-4), Map.entry("korea", 4.156E-4), Map.entry("koreaeast", 4.156E-4), Map.entry("koreasouth", 4.156E-4), Map.entry("india", 7.082E-4), Map.entry("indiacentral", 7.082E-4), Map.entry("centralindia", 7.082E-4), Map.entry("jioindiacentral", 7.082E-4), Map.entry("indiawest", 7.082E-4), Map.entry("westindia", 7.082E-4), Map.entry("jioindiawest", 7.082E-4), Map.entry("indiasouth", 7.082E-4), Map.entry("southindia", 7.082E-4), Map.entry("northeurope", 2.786E-4), Map.entry("europenorth", 2.786E-4), Map.entry("westeurope", 3.284E-4), Map.entry("europewest", 3.284E-4), Map.entry("france", 5.128E-5), Map.entry("francecentral", 5.128E-5), Map.entry("francesouth", 5.128E-5), Map.entry("swedencentral", 5.67E-6), Map.entry("switzerland", 1.152E-5), Map.entry("switzerlandnorth", 1.152E-5), Map.entry("switzerlandwest", 1.152E-5), Map.entry("uk", 2.25E-4), Map.entry("uksouth", 2.25E-4), Map.entry("ukwest", 2.28E-4), Map.entry("germany", 3.3866E-4), Map.entry("germanynorth", 3.3866E-4), Map.entry("germanywestcentral", 3.3866E-4), Map.entry("norway", 7.62E-6), Map.entry("norwayeast", 7.62E-6), Map.entry("norwaywest", 7.62E-6), Map.entry("uae", 4.041E-4), Map.entry("uaenorth", 4.041E-4), Map.entry("uaecentral", 4.041E-4), Map.entry("canada", 1.2E-4), Map.entry("canadacentral", 1.2E-4), Map.entry("canadaeast", 1.2E-4), Map.entry("brazil", 6.17E-5), Map.entry("brazilsouth", 6.17E-5), Map.entry("brazilsoutheast", 6.17E-5))));

    private CloudProviders() {
    }

    private static Provider getProvider(String providerName) {
        return PROVIDERS.get(providerName);
    }

    public static double getPUEOrDefault(String providerName, double defaultPUEValue) {
        Provider provider = CloudProviders.getProvider(providerName);
        if (provider == null) {
            return defaultPUEValue;
        }
        return provider.pue;
    }

    public static double getCO2TonsPerKWHOrDefault(String providerName, String region, double defaultCO2Value) {
        Provider provider = CloudProviders.getProvider(providerName);
        if (provider == null) {
            return defaultCO2Value;
        }
        return provider.co2TonsPerKWH.getOrDefault(region, defaultCO2Value);
    }

    public record Provider(double pue, Map<String, Double> co2TonsPerKWH) {
    }
}

