/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.util;

import java.math.BigInteger;

public abstract class NumericUtils {
    public static final BigInteger UNSIGNED_LONG_MAX = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    public static final double UNSIGNED_LONG_MAX_AS_DOUBLE = UNSIGNED_LONG_MAX.doubleValue();
    public static final long TWOS_COMPLEMENT_BITMASK = Long.MIN_VALUE;
    public static final BigInteger LONG_MAX_PLUS_ONE_AS_BIGINTEGER = BigInteger.ONE.shiftLeft(63);
    public static final double LONG_MAX_PLUS_ONE_AS_DOUBLE = LONG_MAX_PLUS_ONE_AS_BIGINTEGER.doubleValue();
    public static final long ONE_AS_UNSIGNED_LONG = NumericUtils.asLongUnsigned(BigInteger.ONE);
    public static final long ZERO_AS_UNSIGNED_LONG = NumericUtils.asLongUnsigned(BigInteger.ZERO);
    private static final String UNSIGNED_LONG_OVERFLOW = "unsigned_long overflow";

    public static boolean isUnsignedLong(BigInteger bi) {
        return bi.signum() >= 0 && bi.compareTo(UNSIGNED_LONG_MAX) <= 0;
    }

    public static boolean inUnsignedLongRange(double d) {
        return d >= 0.0 && d < UNSIGNED_LONG_MAX_AS_DOUBLE;
    }

    public static BigInteger asUnsignedLong(BigInteger bi) {
        if (!NumericUtils.isUnsignedLong(bi)) {
            throw new ArithmeticException(UNSIGNED_LONG_OVERFLOW);
        }
        return bi;
    }

    public static long asLongUnsigned(BigInteger ul) {
        if (ul.bitLength() < 64) {
            return NumericUtils.twosComplement(ul.longValue());
        }
        return ul.subtract(LONG_MAX_PLUS_ONE_AS_BIGINTEGER).longValue();
    }

    public static long asLongUnsigned(long ul) {
        return NumericUtils.twosComplement(ul);
    }

    public static Number unsignedLongAsNumber(long l) {
        return l < 0L ? Long.valueOf(NumericUtils.twosComplement(l)) : LONG_MAX_PLUS_ONE_AS_BIGINTEGER.add(BigInteger.valueOf(l));
    }

    public static BigInteger unsignedLongAsBigInteger(long l) {
        return l < 0L ? BigInteger.valueOf(NumericUtils.twosComplement(l)) : LONG_MAX_PLUS_ONE_AS_BIGINTEGER.add(BigInteger.valueOf(l));
    }

    public static double unsignedLongToDouble(long l) {
        return l < 0L ? (double)NumericUtils.twosComplement(l) : LONG_MAX_PLUS_ONE_AS_DOUBLE + (double)l;
    }

    public static long unsignedLongAddExact(long x, long y) {
        long s;
        if ((x | y) >= 0L || (s = x + y) >= 0L && (x ^ y) < 0L) {
            throw new ArithmeticException(UNSIGNED_LONG_OVERFLOW);
        }
        return NumericUtils.asLongUnsigned(s);
    }

    public static long unsignedLongSubtractExact(long x, long y) {
        if (x < y) {
            throw new ArithmeticException(UNSIGNED_LONG_OVERFLOW);
        }
        return NumericUtils.asLongUnsigned(x - y);
    }

    public static long unsignedLongMultiplyExact(long x, long y) {
        long uy;
        long ux = NumericUtils.asLongUnsigned(x);
        if (NumericUtils.unsignedLongMultiplyHigh(ux, uy = NumericUtils.asLongUnsigned(y)) != 0L) {
            throw new ArithmeticException(UNSIGNED_LONG_OVERFLOW);
        }
        return NumericUtils.asLongUnsigned(ux * uy);
    }

    public static long unsignedLongMultiplyHigh(long x, long y) {
        return Math.multiplyHigh(x, y) + (y & x >> 63) + (x & y >> 63);
    }

    private static long twosComplement(long l) {
        return l ^ Long.MIN_VALUE;
    }

    public static double asFiniteNumber(double dbl) {
        if (Double.isNaN(dbl) || Double.isInfinite(dbl)) {
            throw new ArithmeticException("not a finite double number: " + dbl);
        }
        return dbl;
    }
}

