/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Strings;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.repositories.azure.AzureBlobStore;
import org.elasticsearch.repositories.azure.AzureStorageService;
import org.elasticsearch.repositories.azure.LocationMode;
import org.elasticsearch.repositories.blobstore.MeteredBlobStoreRepository;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class AzureRepository
extends MeteredBlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(AzureRepository.class);
    public static final String TYPE = "azure";
    private final ByteSizeValue chunkSize;
    private final AzureStorageService storageService;
    private final boolean readonly;

    public AzureRepository(RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, AzureStorageService storageService, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings) {
        super(metadata, namedXContentRegistry, clusterService, bigArrays, recoverySettings, AzureRepository.buildBasePath(metadata), AzureRepository.buildLocation(metadata), MeterRegistry.NOOP);
        this.chunkSize = (ByteSizeValue)Repository.CHUNK_SIZE_SETTING.get(metadata.settings());
        this.storageService = storageService;
        LocationMode locationMode = (LocationMode)((Object)Repository.LOCATION_MODE_SETTING.get(metadata.settings()));
        this.readonly = Repository.READONLY_SETTING.exists(metadata.settings()) ? ((Boolean)Repository.READONLY_SETTING.get(metadata.settings())).booleanValue() : locationMode.isSecondary();
    }

    private static BlobPath buildBasePath(RepositoryMetadata metadata) {
        String basePath = org.elasticsearch.common.Strings.trimLeadingCharacter((String)((String)Repository.BASE_PATH_SETTING.get(metadata.settings())), (char)'/');
        if (org.elasticsearch.common.Strings.hasLength((String)basePath)) {
            BlobPath path = BlobPath.EMPTY;
            for (String elem : basePath.split("/")) {
                path = path.add(elem);
            }
            return path;
        }
        return BlobPath.EMPTY;
    }

    private static Map<String, String> buildLocation(RepositoryMetadata metadata) {
        return Map.of("base_path", (String)Repository.BASE_PATH_SETTING.get(metadata.settings()), "container", (String)Repository.CONTAINER_SETTING.get(metadata.settings()));
    }

    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    protected AzureBlobStore createBlobStore() {
        AzureBlobStore blobStore = new AzureBlobStore(this.metadata, this.storageService, this.bigArrays);
        logger.debug(() -> Strings.format((String)"using container [%s], chunk_size [%s], compress [%s], base_path [%s]", (Object[])new Object[]{blobStore, this.chunkSize, this.isCompress(), this.basePath()}));
        return blobStore;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public static final class Repository {
        @Deprecated
        public static final Setting<String> ACCOUNT_SETTING = new Setting("account", "default", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.DeprecatedWarning});
        public static final Setting<String> CLIENT_NAME = new Setting("client", ACCOUNT_SETTING, Function.identity(), new Setting.Property[0]);
        public static final Setting<String> CONTAINER_SETTING = new Setting("container", "elasticsearch-snapshots", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<LocationMode> LOCATION_MODE_SETTING = new Setting("location_mode", LocationMode.PRIMARY_ONLY.toString(), s -> LocationMode.valueOf(s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)AzureStorageService.MAX_CHUNK_SIZE, (ByteSizeValue)AzureStorageService.MIN_CHUNK_SIZE, (ByteSizeValue)AzureStorageService.MAX_CHUNK_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Boolean> READONLY_SETTING = Setting.boolSetting((String)"readonly", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        private static final ByteSizeValue DEFAULT_MAX_SINGLE_UPLOAD_SIZE = new ByteSizeValue(256L, ByteSizeUnit.MB);
        public static final Setting<ByteSizeValue> MAX_SINGLE_PART_UPLOAD_SIZE_SETTING = Setting.byteSizeSetting((String)"max_single_part_upload_size", (ByteSizeValue)DEFAULT_MAX_SINGLE_UPLOAD_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }
}

