/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm.action;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.action.RetryAction;
import org.elasticsearch.xpack.ilm.IndexLifecycleService;

public class TransportRetryAction
extends TransportMasterNodeAction<RetryAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportRetryAction.class);
    IndexLifecycleService indexLifecycleService;

    @Inject
    public TransportRetryAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexLifecycleService indexLifecycleService) {
        super("indices:admin/ilm/retry", transportService, clusterService, threadPool, actionFilters, RetryAction.Request::new, indexNameExpressionResolver, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexLifecycleService = indexLifecycleService;
    }

    protected void masterOperation(Task task, final RetryAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.submitUnbatchedTask("ilm-re-run", (ClusterStateUpdateTask)new AckedClusterStateUpdateTask((AckedRequest)request, listener){

            public ClusterState execute(ClusterState currentState) {
                return TransportRetryAction.this.indexLifecycleService.moveClusterStateToPreviouslyFailedStep(currentState, request.indices());
            }

            public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                for (String index : request.indices()) {
                    IndexMetadata idxMeta = newState.metadata().index(index);
                    LifecycleExecutionState lifecycleState = idxMeta.getLifecycleExecutionState();
                    Step.StepKey retryStep = new Step.StepKey(lifecycleState.phase(), lifecycleState.action(), lifecycleState.step());
                    if (idxMeta == null) {
                        logger.debug("index [" + index + "] has been deleted after moving to step [" + lifecycleState.step() + "], skipping async action check");
                        return;
                    }
                    TransportRetryAction.this.indexLifecycleService.maybeRunAsyncAction(newState, idxMeta, retryStep);
                }
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    protected ClusterBlockException checkBlock(RetryAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

