/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleStats;
import org.elasticsearch.xpack.core.slm.action.PutSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;

public class TransportPutSnapshotLifecycleAction
extends TransportMasterNodeAction<PutSnapshotLifecycleAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutSnapshotLifecycleAction.class);

    @Inject
    public TransportPutSnapshotLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/slm/put", transportService, clusterService, threadPool, actionFilters, PutSnapshotLifecycleAction.Request::new, indexNameExpressionResolver, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void masterOperation(Task task, PutSnapshotLifecycleAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        SnapshotLifecycleService.validateRepositoryExists(request.getLifecycle().getRepository(), state);
        SnapshotLifecycleService.validateMinimumInterval(request.getLifecycle(), state);
        Map filteredHeaders = ClientHelper.getPersistableSafeSecurityHeaders((ThreadContext)this.threadPool.getThreadContext(), (ClusterState)state);
        LifecyclePolicy.validatePolicyName((String)request.getLifecycleId());
        this.submitUnbatchedTask("put-snapshot-lifecycle-" + request.getLifecycleId(), (ClusterStateUpdateTask)new UpdateSnapshotPolicyTask(request, listener, filteredHeaders));
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    protected ClusterBlockException checkBlock(PutSnapshotLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public Optional<String> reservedStateHandlerName() {
        return Optional.of("slm");
    }

    public Set<String> modifiedKeys(PutSnapshotLifecycleAction.Request request) {
        return Set.of(request.getLifecycleId());
    }

    public static class UpdateSnapshotPolicyTask
    extends AckedClusterStateUpdateTask {
        private final PutSnapshotLifecycleAction.Request request;
        private final Map<String, String> filteredHeaders;

        UpdateSnapshotPolicyTask(PutSnapshotLifecycleAction.Request request, ActionListener<AcknowledgedResponse> listener, Map<String, String> filteredHeaders) {
            super((AckedRequest)request, listener);
            this.request = request;
            this.filteredHeaders = filteredHeaders;
        }

        UpdateSnapshotPolicyTask(PutSnapshotLifecycleAction.Request request) {
            super((AckedRequest)request, null);
            this.request = request;
            this.filteredHeaders = Collections.emptyMap();
        }

        public ClusterState execute(ClusterState currentState) {
            SnapshotLifecycleMetadata lifecycleMetadata;
            SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)currentState.metadata().custom("snapshot_lifecycle");
            OperationMode currentMode = LifecycleOperationMetadata.currentSLMMode((ClusterState)currentState);
            String id = this.request.getLifecycleId();
            if (snapMeta == null) {
                SnapshotLifecyclePolicyMetadata meta = SnapshotLifecyclePolicyMetadata.builder().setPolicy(this.request.getLifecycle()).setHeaders(this.filteredHeaders).setModifiedDate(Instant.now().toEpochMilli()).build();
                lifecycleMetadata = new SnapshotLifecycleMetadata(Collections.singletonMap(id, meta), currentMode, new SnapshotLifecycleStats());
                logger.info("adding new snapshot lifecycle [{}]", (Object)id);
            } else {
                HashMap<String, SnapshotLifecyclePolicyMetadata> snapLifecycles = new HashMap<String, SnapshotLifecyclePolicyMetadata>(snapMeta.getSnapshotConfigurations());
                SnapshotLifecyclePolicyMetadata oldLifecycle = (SnapshotLifecyclePolicyMetadata)snapLifecycles.get(id);
                SnapshotLifecyclePolicyMetadata newLifecycle = SnapshotLifecyclePolicyMetadata.builder((SnapshotLifecyclePolicyMetadata)oldLifecycle).setPolicy(this.request.getLifecycle()).setHeaders(this.filteredHeaders).setVersion(oldLifecycle == null ? 1L : oldLifecycle.getVersion() + 1L).setModifiedDate(Instant.now().toEpochMilli()).build();
                snapLifecycles.put(id, newLifecycle);
                lifecycleMetadata = new SnapshotLifecycleMetadata(snapLifecycles, currentMode, snapMeta.getStats());
                if (oldLifecycle == null) {
                    logger.info("adding new snapshot lifecycle [{}]", (Object)id);
                } else {
                    logger.info("updating existing snapshot lifecycle [{}]", (Object)id);
                }
            }
            Metadata currentMeta = currentState.metadata();
            return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentMeta).putCustom("snapshot_lifecycle", (Metadata.Custom)lifecycleMetadata)).build();
        }
    }
}

