/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.action.DeleteSnapshotLifecycleAction;

public class TransportDeleteSnapshotLifecycleAction
extends TransportMasterNodeAction<DeleteSnapshotLifecycleAction.Request, AcknowledgedResponse> {
    @Inject
    public TransportDeleteSnapshotLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/slm/delete", transportService, clusterService, threadPool, actionFilters, DeleteSnapshotLifecycleAction.Request::new, indexNameExpressionResolver, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void masterOperation(Task task, DeleteSnapshotLifecycleAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.submitUnbatchedTask("delete-snapshot-lifecycle-" + request.getLifecycleId(), (ClusterStateUpdateTask)new DeleteSnapshotPolicyTask(request, listener));
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    protected ClusterBlockException checkBlock(DeleteSnapshotLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public Optional<String> reservedStateHandlerName() {
        return Optional.of("slm");
    }

    public Set<String> modifiedKeys(DeleteSnapshotLifecycleAction.Request request) {
        return Set.of(request.getLifecycleId());
    }

    public static class DeleteSnapshotPolicyTask
    extends AckedClusterStateUpdateTask {
        private final DeleteSnapshotLifecycleAction.Request request;

        DeleteSnapshotPolicyTask(DeleteSnapshotLifecycleAction.Request request, ActionListener<AcknowledgedResponse> listener) {
            super((AckedRequest)request, listener);
            this.request = request;
        }

        DeleteSnapshotPolicyTask(String policyId) {
            this(new DeleteSnapshotLifecycleAction.Request(policyId), null);
        }

        public ClusterState execute(ClusterState currentState) {
            SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)currentState.metadata().custom("snapshot_lifecycle");
            if (snapMeta == null) {
                throw new ResourceNotFoundException("snapshot lifecycle policy not found: {}", new Object[]{this.request.getLifecycleId()});
            }
            OperationMode currentMode = LifecycleOperationMetadata.currentSLMMode((ClusterState)currentState);
            snapMeta.getSnapshotConfigurations().entrySet().stream().filter(e -> ((SnapshotLifecyclePolicyMetadata)e.getValue()).getPolicy().getId().equals(this.request.getLifecycleId())).findAny().orElseThrow(() -> new ResourceNotFoundException("snapshot lifecycle policy not found: {}", new Object[]{this.request.getLifecycleId()}));
            Map<String, SnapshotLifecyclePolicyMetadata> newConfigs = snapMeta.getSnapshotConfigurations().entrySet().stream().filter(e -> !((String)e.getKey()).equals(this.request.getLifecycleId())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Metadata metadata = currentState.metadata();
            return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)metadata).putCustom("snapshot_lifecycle", (Metadata.Custom)new SnapshotLifecycleMetadata(newConfigs, currentMode, snapMeta.getStats().removePolicy(this.request.getLifecycleId())))).build();
        }
    }
}

