/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.index;

import java.io.IOException;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.lucene.bwc.codecs.index.LegacySortedSetDocValues;

@Deprecated
public final class LegacySortedSetDocValuesWrapper
extends SortedSetDocValues {
    private final LegacySortedSetDocValues values;
    private final int maxDoc;
    private int docID = -1;
    private long ord;

    public LegacySortedSetDocValuesWrapper(LegacySortedSetDocValues values, int maxDoc) {
        this.values = values;
        this.maxDoc = maxDoc;
    }

    public int docID() {
        return this.docID;
    }

    public int nextDoc() {
        assert (this.docID != Integer.MAX_VALUE);
        ++this.docID;
        while (this.docID < this.maxDoc) {
            this.values.setDocument(this.docID);
            this.ord = this.values.nextOrd();
            if (this.ord != -1L) {
                return this.docID;
            }
            ++this.docID;
        }
        this.docID = Integer.MAX_VALUE;
        return Integer.MAX_VALUE;
    }

    public int advance(int target) {
        if (target < this.docID) {
            throw new IllegalArgumentException("cannot advance backwards: docID=" + this.docID + " target=" + target);
        }
        if (target >= this.maxDoc) {
            this.docID = Integer.MAX_VALUE;
        } else {
            this.docID = target - 1;
            this.nextDoc();
        }
        return this.docID;
    }

    public boolean advanceExact(int target) throws IOException {
        this.docID = target;
        this.values.setDocument(this.docID);
        this.ord = this.values.nextOrd();
        return this.ord != -1L;
    }

    public long cost() {
        return 0L;
    }

    public long nextOrd() {
        long result = this.ord;
        if (result != -1L) {
            this.ord = this.values.nextOrd();
        }
        return result;
    }

    public int docValueCount() {
        return this.values.docValueCount();
    }

    public BytesRef lookupOrd(long ord) {
        return this.values.lookupOrd((int)ord);
    }

    public long getValueCount() {
        return this.values.getValueCount();
    }

    public String toString() {
        return "LegacySortedSetDocValuesWrapper(" + this.values + ")";
    }
}

