/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.List;
import java.util.concurrent.atomic.DoubleAdder;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.structure.ElementView1D;
import org.ojalgo.structure.Factory1D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

public interface Access1D<N extends Comparable<N>>
extends Structure1D {
    public static Access1D<Double> asPrimitive1D(final Access1D<?> access) {
        return new Access1D<Double>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public Double get(long index) {
                return access.doubleValue(index);
            }

            public String toString() {
                return Access1D.toString(this);
            }
        };
    }

    public static boolean equals(Access1D<?> accessA, Access1D<?> accessB, NumberContext accuracy) {
        long length = accessA.count();
        if (length != accessB.count()) {
            return false;
        }
        double magnitudeA = 0.0;
        for (long i = 0L; i < length; ++i) {
            magnitudeA = Math.max(magnitudeA, Math.abs(accessA.doubleValue(i)));
        }
        double magnitudeB = 0.0;
        for (long i = 0L; i < length; ++i) {
            magnitudeB = Math.max(magnitudeB, Math.abs(accessB.doubleValue(i)));
        }
        if (accuracy.isDifferent(magnitudeA, magnitudeB)) {
            return false;
        }
        double magnitude = Math.max(magnitudeA, magnitudeB);
        for (long i = 0L; i < length; ++i) {
            if (accuracy.isSmall(magnitude, accessA.doubleValue(i) - accessB.doubleValue(i))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static int hashCode(Access1D<?> access) {
        int limit = access.size();
        int retVal = limit + 31;
        for (int ij = 0; ij < limit; ++ij) {
            retVal *= access.intValue(ij);
        }
        return retVal;
    }

    public static String toString(Access1D<?> access) {
        int size = access.size();
        switch (size) {
            case 0: {
                return "{ }";
            }
            case 1: {
                return "{ " + access.get(0L) + " }";
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        builder.append(access.get(0L));
        for (int i = 1; i < size; ++i) {
            builder.append(", ");
            builder.append(access.get(i));
        }
        builder.append(" }");
        return builder.toString();
    }

    public static Access1D<Double> wrap(final double ... target) {
        return new Access1D<Double>(){

            @Override
            public long count() {
                return target.length;
            }

            @Override
            public double doubleValue(long index) {
                return target[Math.toIntExact(index)];
            }

            @Override
            public Double get(long index) {
                return this.doubleValue(index);
            }

            public String toString() {
                return Access1D.toString(this);
            }
        };
    }

    public static <N extends Comparable<N>> Access1D<N> wrap(final List<? extends N> target) {
        return new Access1D<N>(){

            @Override
            public long count() {
                return target.size();
            }

            @Override
            public double doubleValue(long index) {
                return NumberDefinition.doubleValue((Comparable)target.get((int)index));
            }

            @Override
            public N get(long index) {
                return (Comparable)target.get((int)index);
            }

            public String toString() {
                return Access1D.toString(this);
            }
        };
    }

    public static <N extends Comparable<N>> Access1D<N> wrap(N[] target) {
        return new Access1D<N>((Comparable[])target){
            final /* synthetic */ Comparable[] val$target;
            {
                this.val$target = comparableArray;
            }

            @Override
            public long count() {
                return this.val$target.length;
            }

            @Override
            public double doubleValue(long index) {
                return NumberDefinition.doubleValue(this.val$target[(int)index]);
            }

            @Override
            public N get(long index) {
                return this.val$target[(int)index];
            }

            public String toString() {
                return Access1D.toString(this);
            }
        };
    }

    default public <NN extends Comparable<NN>, R extends Mutate1D.Receiver<NN>> Collectable<NN, R> asCollectable1D() {
        return new Collectable<NN, R>(){

            @Override
            public long count() {
                return Access1D.this.count();
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.accept(Access1D.this);
            }
        };
    }

    default public void axpy(double a, Mutate1D.Modifiable<?> y) {
        Structure1D.loopMatching(this, y, i -> y.add(i, a * this.doubleValue(i)));
    }

    default public byte byteValue(long index) {
        return (byte)this.shortValue(index);
    }

    default public double dot(Access1D<?> vector) {
        DoubleAdder retVal = new DoubleAdder();
        Structure1D.loopMatching(this, vector, i -> retVal.add(this.doubleValue(i) * vector.doubleValue(i)));
        return retVal.doubleValue();
    }

    public double doubleValue(long var1);

    default public ElementView1D<N, ?> elements() {
        return new ElementView(this);
    }

    default public float floatValue(long index) {
        return (float)this.doubleValue(index);
    }

    public N get(long var1);

    default public int intValue(long index) {
        return (int)this.longValue(index);
    }

    default public long longValue(long index) {
        return Math.round(this.doubleValue(index));
    }

    default public ElementView1D<N, ?> nonzeros() {
        return this.elements();
    }

    default public short shortValue(long index) {
        return (short)this.intValue(index);
    }

    default public void supplyTo(double[] receiver) {
        int limit = Math.min(receiver.length, (int)this.count());
        for (int i = 0; i < limit; ++i) {
            receiver[i] = this.doubleValue(i);
        }
    }

    default public double[] toRawCopy1D() {
        int tmpLength = (int)this.count();
        double[] retVal = new double[tmpLength];
        this.supplyTo(retVal);
        return retVal;
    }

    public static interface Visitable<N extends Comparable<N>>
    extends Structure1D {
        default public void visitAll(VoidFunction<N> visitor) {
            this.visitRange(0L, this.count(), visitor);
        }

        public void visitOne(long var1, VoidFunction<N> var3);

        default public void visitRange(long first, long limit, VoidFunction<N> visitor) {
            Structure1D.loopRange(first, limit, i -> this.visitOne(i, visitor));
        }
    }

    public static interface Sliceable<N extends Comparable<N>>
    extends Structure1D {
        public Access1D<N> sliceRange(long var1, long var3);
    }

    public static class ElementView<N extends Comparable<N>>
    implements ElementView1D<N, ElementView<N>> {
        private long myCursor;
        private long myLastCursor;
        private final Access1D<N> myValues;

        private ElementView(Access1D<N> values, long initial, long last) {
            this.myValues = values;
            this.myCursor = initial;
            this.myLastCursor = last;
        }

        ElementView(Access1D<N> values) {
            this(values, -1L, values.count() - 1L);
        }

        @Override
        public double doubleValue() {
            return this.myValues.doubleValue(this.myCursor);
        }

        @Override
        public long estimateSize() {
            return this.myLastCursor - this.myCursor;
        }

        @Override
        public N get() {
            return this.myValues.get(this.myCursor);
        }

        @Override
        public boolean hasNext() {
            return this.myCursor < this.myLastCursor;
        }

        @Override
        public boolean hasPrevious() {
            return this.myCursor > 0L;
        }

        @Override
        public long index() {
            return this.myCursor;
        }

        @Override
        public ElementView<N> iterator() {
            return new ElementView<N>(this.myValues);
        }

        @Override
        public ElementView<N> next() {
            ++this.myCursor;
            return this;
        }

        @Override
        public ElementView<N> previous() {
            --this.myCursor;
            return this;
        }

        public String toString() {
            return this.myCursor + " = " + this.myValues.get(this.myCursor);
        }

        @Override
        public ElementView<N> trySplit() {
            long remaining = this.myLastCursor - this.myCursor;
            if (remaining > 1L) {
                long split = this.myCursor + remaining / 2L;
                ElementView<N> retVal = new ElementView<N>(this.myValues, this.myCursor, split);
                this.myCursor = split;
                return retVal;
            }
            return null;
        }
    }

    public static interface Collectable<N extends Comparable<N>, R extends Mutate1D>
    extends Structure1D {
        default public <I extends R> I collect(Factory1D<I> factory) {
            Mutate1D retVal = (Mutate1D)factory.make(this.count());
            this.supplyTo(retVal);
            return (I)retVal;
        }

        public void supplyTo(R var1);
    }

    public static interface Aggregatable<N extends Comparable<N>>
    extends Structure1D {
        default public N aggregateAll(Aggregator aggregator) {
            return this.aggregateRange(0L, this.count(), aggregator);
        }

        public N aggregateRange(long var1, long var3, Aggregator var5);

        public long indexOfLargest();
    }
}

