/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.local;

import java.util.Arrays;
import java.util.Collection;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringTemplateUtils;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.ExportException;

public class LocalBulk
extends ExportBulk {
    private final Logger logger;
    private final Client client;
    private final DateFormatter formatter;
    private BulkRequestBuilder requestBuilder;

    LocalBulk(String name, Logger logger, Client client, DateFormatter dateTimeFormatter) {
        super(name, client.threadPool().getThreadContext());
        this.logger = logger;
        this.client = client;
        this.formatter = dateTimeFormatter;
    }

    @Override
    protected void doAdd(Collection<MonitoringDoc> docs) throws ExportException {
        ExportException exception = null;
        for (MonitoringDoc doc : docs) {
            if (this.requestBuilder == null) {
                this.requestBuilder = this.client.prepareBulk();
            }
            try {
                String index = MonitoringTemplateUtils.indexName((DateFormatter)this.formatter, (MonitoredSystem)doc.getSystem(), (long)doc.getTimestamp());
                IndexRequest request = new IndexRequest(index);
                if (Strings.hasText((String)doc.getId())) {
                    request.id(doc.getId());
                }
                BytesReference source = XContentHelper.toXContent((ToXContent)doc, (XContentType)XContentType.SMILE, (boolean)false);
                request.source(source, XContentType.SMILE);
                this.requestBuilder.add(request);
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("local exporter [{}] - added index request [index={}, id={}, pipeline={}, monitoring data type={}]", (Object)this.name, (Object)request.index(), (Object)request.id(), (Object)request.getPipeline(), (Object)doc.getType());
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = new ExportException("failed to add documents to export bulk [{}]", this.name);
                }
                exception.addExportException(new ExportException("failed to add document [{}]", e, doc, this.name));
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    protected void doFlush(ActionListener<Void> listener) {
        if (this.requestBuilder == null || this.requestBuilder.numberOfActions() == 0) {
            listener.onResponse(null);
        } else {
            try {
                this.logger.trace("exporter [{}] - exporting {} documents", (Object)this.name, (Object)this.requestBuilder.numberOfActions());
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"monitoring", (ActionRequest)((BulkRequest)this.requestBuilder.request()), (ActionListener)ActionListener.wrap(bulkResponse -> {
                    if (bulkResponse.hasFailures()) {
                        this.throwExportException(bulkResponse.getItems(), listener);
                    } else {
                        listener.onResponse(null);
                    }
                }, e -> listener.onFailure((Exception)((Object)new ExportException("failed to flush export bulk [{}]", (Throwable)e, (Object)this.name)))), (arg_0, arg_1) -> ((Client)this.client).bulk(arg_0, arg_1));
            }
            finally {
                this.requestBuilder = null;
            }
        }
    }

    void throwExportException(BulkItemResponse[] bulkItemResponses, ActionListener<Void> listener) {
        ExportException exception = new ExportException("bulk [{}] reports failures when exporting documents", this.name);
        Arrays.stream(bulkItemResponses).filter(BulkItemResponse::isFailed).map(item -> new ExportException(item.getFailure().getCause())).forEach(exception::addExportException);
        if (exception.hasExportExceptions()) {
            for (ExportException e : exception) {
                this.logger.warn("unexpected error while indexing monitoring document", (Throwable)((Object)e));
            }
            listener.onFailure((Exception)((Object)exception));
        } else {
            listener.onResponse(null);
        }
    }
}

