/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.monitoring.MonitoringDeprecatedSettings;
import org.elasticsearch.xpack.core.monitoring.MonitoringField;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkAction;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringMigrateAlertsAction;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.monitoring.MonitoringInfoTransportAction;
import org.elasticsearch.xpack.monitoring.MonitoringService;
import org.elasticsearch.xpack.monitoring.MonitoringTemplateRegistry;
import org.elasticsearch.xpack.monitoring.MonitoringUsageServices;
import org.elasticsearch.xpack.monitoring.MonitoringUsageTransportAction;
import org.elasticsearch.xpack.monitoring.action.TransportMonitoringBulkAction;
import org.elasticsearch.xpack.monitoring.action.TransportMonitoringMigrateAlertsAction;
import org.elasticsearch.xpack.monitoring.cleaner.CleanerService;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.ccr.StatsCollector;
import org.elasticsearch.xpack.monitoring.collector.cluster.ClusterStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.enrich.EnrichStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexRecoveryCollector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.ml.JobStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.node.NodeStatsCollector;
import org.elasticsearch.xpack.monitoring.collector.shards.ShardsCollector;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringMigrationCoordinator;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExporter;
import org.elasticsearch.xpack.monitoring.exporter.local.LocalExporter;
import org.elasticsearch.xpack.monitoring.rest.action.RestMonitoringBulkAction;
import org.elasticsearch.xpack.monitoring.rest.action.RestMonitoringMigrateAlertsAction;

public class Monitoring
extends Plugin
implements ActionPlugin,
ReloadablePlugin {
    public static final Setting<Boolean> MIGRATION_DECOMMISSION_ALERTS = Setting.boolSetting((String)"xpack.monitoring.migration.decommission_alerts", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.DeprecatedWarning});
    public static final LicensedFeature.Momentary MONITORING_CLUSTER_ALERTS_FEATURE = LicensedFeature.momentary((String)"monitoring", (String)"cluster-alerts", (License.OperationMode)License.OperationMode.STANDARD);
    protected final Settings settings;
    private Exporters exporters;

    public Monitoring(Settings settings) {
        this.settings = settings;
    }

    protected SSLService getSslService() {
        return XPackPlugin.getSharedSslService();
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    protected LicenseService getLicenseService() {
        return XPackPlugin.getSharedLicenseService();
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        Client client = services.client();
        ClusterService clusterService = services.clusterService();
        ThreadPool threadPool = services.threadPool();
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        CleanerService cleanerService = new CleanerService(this.settings, clusterSettings, threadPool);
        SSLService dynamicSSLService = this.getSslService().createDynamicSSLService();
        MonitoringMigrationCoordinator migrationCoordinator = new MonitoringMigrationCoordinator();
        HashMap<String, Exporter.Factory> exporterFactories = new HashMap<String, Exporter.Factory>();
        exporterFactories.put("http", config -> new HttpExporter(config, dynamicSSLService, threadPool.getThreadContext(), migrationCoordinator));
        exporterFactories.put("local", config -> new LocalExporter(config, client, migrationCoordinator, cleanerService));
        this.exporters = new Exporters(this.settings, exporterFactories, clusterService, this.getLicenseState(), threadPool.getThreadContext(), dynamicSSLService);
        HashSet<Collector> collectors = new HashSet<Collector>();
        collectors.add(new IndexStatsCollector(clusterService, this.getLicenseState(), client));
        collectors.add(new ClusterStatsCollector(this.settings, clusterService, this.getLicenseState(), client, this.getLicenseService(), services.indexNameExpressionResolver()));
        collectors.add(new ShardsCollector(clusterService, this.getLicenseState()));
        collectors.add(new NodeStatsCollector(clusterService, this.getLicenseState(), client));
        collectors.add(new IndexRecoveryCollector(clusterService, this.getLicenseState(), client));
        collectors.add(new JobStatsCollector(this.settings, clusterService, this.getLicenseState(), client));
        collectors.add(new StatsCollector(this.settings, clusterService, this.getLicenseState(), client));
        collectors.add(new EnrichStatsCollector(clusterService, this.getLicenseState(), client));
        MonitoringService monitoringService = new MonitoringService(this.settings, clusterService, threadPool, collectors, this.exporters);
        MonitoringUsageServices usageServices = new MonitoringUsageServices(monitoringService, this.exporters);
        MonitoringTemplateRegistry templateRegistry = new MonitoringTemplateRegistry(this.settings, clusterService, threadPool, client, services.xContentRegistry());
        templateRegistry.initialize();
        return Arrays.asList(new Object[]{monitoringService, this.exporters, migrationCoordinator, cleanerService, usageServices, templateRegistry});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ActionPlugin.ActionHandler usageAction = new ActionPlugin.ActionHandler((ActionType)XPackUsageFeatureAction.MONITORING, MonitoringUsageTransportAction.class);
        ActionPlugin.ActionHandler infoAction = new ActionPlugin.ActionHandler((ActionType)XPackInfoFeatureAction.MONITORING, MonitoringInfoTransportAction.class);
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)MonitoringBulkAction.INSTANCE, TransportMonitoringBulkAction.class), new ActionPlugin.ActionHandler((ActionType)MonitoringMigrateAlertsAction.INSTANCE, TransportMonitoringMigrateAlertsAction.class), usageAction, infoAction);
    }

    public List<RestHandler> getRestHandlers(Settings unused, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestMonitoringBulkAction(), new RestMonitoringMigrateAlertsAction());
    }

    public List<Setting<?>> getSettings() {
        ArrayList<Object> settingsList = new ArrayList<Object>();
        settingsList.add(MonitoringField.HISTORY_DURATION);
        settingsList.add(MonitoringService.ENABLED);
        settingsList.add(MonitoringService.ELASTICSEARCH_COLLECTION_ENABLED);
        settingsList.add(MonitoringService.INTERVAL);
        settingsList.add(MonitoringTemplateRegistry.MONITORING_TEMPLATES_ENABLED);
        settingsList.add(Collector.INDICES);
        settingsList.add(ClusterStatsCollector.CLUSTER_STATS_TIMEOUT);
        settingsList.add(IndexRecoveryCollector.INDEX_RECOVERY_TIMEOUT);
        settingsList.add(IndexRecoveryCollector.INDEX_RECOVERY_ACTIVE_ONLY);
        settingsList.add(IndexStatsCollector.INDEX_STATS_TIMEOUT);
        settingsList.add(JobStatsCollector.JOB_STATS_TIMEOUT);
        settingsList.add(StatsCollector.CCR_STATS_TIMEOUT);
        settingsList.add(NodeStatsCollector.NODE_STATS_TIMEOUT);
        settingsList.add(EnrichStatsCollector.STATS_TIMEOUT);
        settingsList.addAll(Exporters.getSettings());
        settingsList.add(MIGRATION_DECOMMISSION_ALERTS);
        settingsList.addAll(MonitoringDeprecatedSettings.getSettings());
        return Collections.unmodifiableList(settingsList);
    }

    public List<String> getSettingsFilter() {
        String exportersKey = "xpack.monitoring.exporters.";
        return List.of("xpack.monitoring.exporters.*.auth.*", "xpack.monitoring.exporters.*.ssl.*");
    }

    public void reload(Settings settingsToLoad) throws Exception {
        List<String> changedExporters = HttpExporter.loadSettings(settingsToLoad);
        for (String changedExporter : changedExporters) {
            Settings settingsForChangedExporter = settingsToLoad.filter(x -> x.startsWith("xpack.monitoring.exporters." + changedExporter));
            this.exporters.setExportersSetting(settingsForChangedExporter);
        }
    }

    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return map -> {
            map.remove(".monitoring-alerts");
            return map;
        };
    }
}

