/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.job;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.rest.RestCompatibilityChecker;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetJobsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)("/_ml/anomaly_detectors/{" + Job.ID + "}")).replaces(RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID + "}", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_ml/anomaly_detectors").replaces(RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_get_jobs_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String jobId = restRequest.param(Job.ID.getPreferredName());
        if (Strings.isNullOrEmpty((String)jobId)) {
            jobId = "_all";
        }
        GetJobsAction.Request request = new GetJobsAction.Request(jobId);
        RestCompatibilityChecker.checkAndSetDeprecatedParam("allow_no_jobs", "allow_no_match", RestApiVersion.V_7, restRequest, (r, s) -> r.paramAsBoolean(s, request.allowNoMatch()), arg_0 -> ((GetJobsAction.Request)request).setAllowNoMatch(arg_0));
        return channel -> new RestCancellableNodeClient(client, restRequest.getHttpChannel()).execute((ActionType)GetJobsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }

    protected Set<String> responseParams() {
        return Collections.singleton("exclude_generated");
    }
}

