/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.inference.nlp;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Vocabulary
implements Writeable,
ToXContentObject {
    private static final String NAME = "vocabulary";
    public static final ParseField VOCABULARY = new ParseField("vocabulary", new String[0]);
    public static final ParseField MERGES = new ParseField("merges", new String[0]);
    public static final ParseField SCORES = new ParseField("scores", new String[0]);
    public static ConstructingObjectParser<Vocabulary, Void> PARSER = Vocabulary.createParser(true);
    private final List<String> vocab;
    private final List<String> merges;
    private final List<Double> scores;
    private final String modelId;

    public static ConstructingObjectParser<Vocabulary, Void> createParser(boolean ignoreUnkownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnkownFields, a -> new Vocabulary((List)a[0], (String)a[1], (List)a[2], (List)a[3]));
        parser.declareStringArray(ConstructingObjectParser.constructorArg(), VOCABULARY);
        parser.declareString(ConstructingObjectParser.constructorArg(), TrainedModelConfig.MODEL_ID);
        parser.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), MERGES);
        parser.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), SCORES);
        return parser;
    }

    public Vocabulary(List<String> vocab, String modelId, @Nullable List<String> merges, @Nullable List<Double> scores) {
        this.vocab = (List)ExceptionsHelper.requireNonNull(vocab, (ParseField)VOCABULARY);
        this.modelId = (String)ExceptionsHelper.requireNonNull((Object)modelId, (ParseField)TrainedModelConfig.MODEL_ID);
        this.merges = Optional.ofNullable(merges).orElse(List.of());
        this.scores = Optional.ofNullable(scores).orElse(List.of());
    }

    public Vocabulary(StreamInput in) throws IOException {
        this.vocab = in.readStringCollectionAsList();
        this.modelId = in.readString();
        this.merges = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_2_0) ? in.readStringCollectionAsList() : List.of();
        this.scores = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_500_020) ? in.readCollectionAsList(StreamInput::readDouble) : List.of();
    }

    public List<String> get() {
        return this.vocab;
    }

    public List<String> merges() {
        return this.merges;
    }

    public List<Double> scores() {
        return this.scores;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.vocab);
        out.writeString(this.modelId);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_2_0)) {
            out.writeStringCollection(this.merges);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_500_020)) {
            out.writeCollection(this.scores, StreamOutput::writeDouble);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vocabulary that = (Vocabulary)o;
        return Objects.equals(this.vocab, that.vocab) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.merges, that.merges) && Objects.equals(this.scores, that.scores);
    }

    public int hashCode() {
        return Objects.hash(this.vocab, this.modelId, this.merges, this.scores);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VOCABULARY.getPreferredName(), this.vocab);
        builder.field(TrainedModelConfig.MODEL_ID.getPreferredName(), this.modelId);
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(InferenceIndexConstants.DOC_TYPE.getPreferredName(), NAME);
        }
        if (!this.merges.isEmpty()) {
            builder.field(MERGES.getPreferredName(), this.merges);
        }
        if (!this.scores.isEmpty()) {
            builder.field(SCORES.getPreferredName(), this.scores);
        }
        builder.endObject();
        return builder;
    }
}

