/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.extractor;

import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.StandardValidator;
import org.elasticsearch.geometry.utils.WellKnownText;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ml.extractor.SourceField;

public class GeoShapeField
extends SourceField {
    static final String TYPE = "geo_shape";
    private static final Set<String> TYPES = Collections.singleton("geo_shape");

    public GeoShapeField(String name) {
        super(name, TYPES);
    }

    @Override
    public Object[] value(SearchHit hit) {
        Object[] value = super.value(hit);
        if (value.length == 0) {
            return value;
        }
        if (value.length > 1) {
            throw new IllegalStateException("Unexpected values for a geo_shape field: " + Arrays.toString(value));
        }
        Object object = value[0];
        if (object instanceof String) {
            String stringValue = (String)object;
            value[0] = GeoShapeField.handleString(stringValue);
        } else if (value[0] instanceof Map) {
            Map geoObject = (Map)value[0];
            value[0] = GeoShapeField.handleObject(geoObject);
        } else {
            throw new IllegalStateException("Unexpected value type for a geo_shape field: " + value[0].getClass());
        }
        return value;
    }

    private static String handleString(String geoString) {
        try {
            if (geoString.startsWith("POINT")) {
                Geometry geometry = WellKnownText.fromWKT((GeometryValidator)StandardValidator.instance((boolean)true), (boolean)true, (String)geoString);
                if (geometry.type() != ShapeType.POINT) {
                    throw new IllegalArgumentException("Unexpected non-point geo_shape type: " + geometry.type().name());
                }
                Point pt = (Point)geometry;
                return pt.getY() + "," + pt.getX();
            }
            throw new IllegalArgumentException("Unexpected value for a geo_shape field: " + geoString);
        }
        catch (IOException | ParseException ex) {
            throw new IllegalArgumentException("Unexpected value for a geo_shape field: " + geoString);
        }
    }

    private static String handleObject(Map<String, Object> geoObject) {
        String geoType = (String)geoObject.get("type");
        if (geoType != null && "point".equals(geoType.toLowerCase(Locale.ROOT))) {
            List coordinates = (List)geoObject.get("coordinates");
            if (coordinates == null || coordinates.size() != 2) {
                throw new IllegalArgumentException("Invalid coordinates for geo_shape point: " + geoObject);
            }
            return coordinates.get(1) + "," + coordinates.get(0);
        }
        throw new IllegalArgumentException("Unexpected value for a geo_shape field: " + geoObject);
    }
}

