/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.steps;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.stats.common.DataCounts;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsTask;
import org.elasticsearch.xpack.ml.dataframe.steps.AbstractDataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.DataFrameAnalyticsStep;
import org.elasticsearch.xpack.ml.dataframe.steps.StepResponse;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;

public class FinalStep
extends AbstractDataFrameAnalyticsStep {
    private static final Logger LOGGER = LogManager.getLogger(FinalStep.class);

    public FinalStep(NodeClient client, DataFrameAnalyticsTask task, DataFrameAnalyticsAuditor auditor, DataFrameAnalyticsConfig config) {
        super(client, task, auditor, config);
    }

    @Override
    public DataFrameAnalyticsStep.Name name() {
        return DataFrameAnalyticsStep.Name.FINAL;
    }

    @Override
    protected void doExecute(ActionListener<StepResponse> listener) {
        ActionListener refreshListener = ActionListener.wrap(refreshResponse -> listener.onResponse((Object)new StepResponse(false)), arg_0 -> listener.onFailure(arg_0));
        ActionListener dataCountsIndexedListener = ActionListener.wrap(indexResponse -> this.refreshIndices((ActionListener<RefreshResponse>)refreshListener), arg_0 -> listener.onFailure(arg_0));
        this.indexDataCounts((ActionListener<DocWriteResponse>)dataCountsIndexedListener);
    }

    private void indexDataCounts(ActionListener<DocWriteResponse> listener) {
        DataCounts dataCounts = this.task.getStatsHolder().getDataCountsTracker().report();
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            dataCounts.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("for_internal_storage", "true")));
            IndexRequest indexRequest = new IndexRequest(MlStatsIndex.writeAlias()).id(DataCounts.documentId((String)this.config.getId())).setRequireAlias(true).source(builder);
            ClientHelper.executeAsyncWithOrigin((Client)this.parentTaskClient(), (String)"ml", (ActionType)IndexAction.INSTANCE, (ActionRequest)indexRequest, listener);
        }
        catch (IOException e) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"[{}] Error persisting final data counts", (Throwable)e, (Object[])new Object[]{this.config.getId()})));
        }
    }

    private void refreshIndices(ActionListener<RefreshResponse> listener) {
        RefreshRequest refreshRequest = new RefreshRequest(new String[]{AnomalyDetectorsIndex.jobStateIndexPattern(), MlStatsIndex.indexPattern(), this.config.getDest().getIndex()});
        refreshRequest.indicesOptions(IndicesOptions.lenientExpandOpen());
        LOGGER.debug(() -> Strings.format((String)"[%s] Refreshing indices %s", (Object[])new Object[]{this.config.getId(), Arrays.toString(refreshRequest.indices())}));
        ClientHelper.executeAsyncWithOrigin((Client)this.parentTaskClient(), (String)"ml", (ActionType)RefreshAction.INSTANCE, (ActionRequest)refreshRequest, listener);
    }

    @Override
    public void cancel(String reason, TimeValue timeout) {
    }

    @Override
    public void updateProgress(ActionListener<Void> listener) {
        listener.onResponse(null);
    }

    @Override
    protected boolean shouldSkipIfTaskIsStopping() {
        return false;
    }
}

