/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.delayeddatacheck;

import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetBucketsAction;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.ExtractorUtils;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.utils.Intervals;
import org.elasticsearch.xpack.ml.datafeed.delayeddatacheck.DelayedDataDetector;
import org.elasticsearch.xpack.ml.datafeed.delayeddatacheck.DelayedDataDetectorFactory;

public class DatafeedDelayedDataDetector
implements DelayedDataDetector {
    private static final String DATE_BUCKETS = "date_buckets";
    private final long bucketSpan;
    private final long window;
    private final Client client;
    private final String timeField;
    private final String jobId;
    private final QueryBuilder datafeedQuery;
    private final String[] datafeedIndices;
    private final IndicesOptions indicesOptions;
    private final Map<String, Object> runtimeMappings;

    DatafeedDelayedDataDetector(long bucketSpan, long window, String jobId, String timeField, QueryBuilder datafeedQuery, String[] datafeedIndices, IndicesOptions indicesOptions, Map<String, Object> runtimeMappings, Client client) {
        this.bucketSpan = bucketSpan;
        this.window = window;
        this.jobId = jobId;
        this.timeField = timeField;
        this.datafeedQuery = datafeedQuery;
        this.datafeedIndices = datafeedIndices;
        this.indicesOptions = Objects.requireNonNull(indicesOptions);
        this.runtimeMappings = Objects.requireNonNull(runtimeMappings);
        this.client = client;
    }

    @Override
    public List<DelayedDataDetectorFactory.BucketWithMissingData> detectMissingData(long latestFinalizedBucketMs) {
        long start;
        long end = Intervals.alignToFloor((long)latestFinalizedBucketMs, (long)this.bucketSpan);
        if (end <= (start = Intervals.alignToFloor((long)(latestFinalizedBucketMs - this.window), (long)this.bucketSpan))) {
            return Collections.emptyList();
        }
        List<Bucket> finalizedBuckets = this.checkBucketEvents(start, end);
        Map<Long, Long> indexedData = this.checkCurrentBucketEventCount(start, end);
        return finalizedBuckets.stream().filter(bucket -> DatafeedDelayedDataDetector.calculateMissing(indexedData, bucket) > 0L).map(bucket -> DelayedDataDetectorFactory.BucketWithMissingData.fromMissingAndBucket(DatafeedDelayedDataDetector.calculateMissing(indexedData, bucket), bucket)).collect(Collectors.toList());
    }

    @Override
    public long getWindow() {
        return this.window;
    }

    private List<Bucket> checkBucketEvents(long start, long end) {
        GetBucketsAction.Request request = new GetBucketsAction.Request(this.jobId);
        request.setStart(Long.toString(start));
        request.setEnd(Long.toString(end));
        request.setSort("timestamp");
        request.setDescending(false);
        request.setExcludeInterim(true);
        request.setPageParams(new PageParams(0, (int)((end - start) / this.bucketSpan)));
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            GetBucketsAction.Response response = (GetBucketsAction.Response)this.client.execute((ActionType)GetBucketsAction.INSTANCE, (ActionRequest)request).actionGet();
            List list = response.getBuckets().results();
            return list;
        }
    }

    private Map<Long, Long> checkCurrentBucketEventCount(long start, long end) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).aggregation((AggregationBuilder)new DateHistogramAggregationBuilder(DATE_BUCKETS).fixedInterval(new DateHistogramInterval(this.bucketSpan + "ms")).field(this.timeField)).query(ExtractorUtils.wrapInTimeRangeQuery((QueryBuilder)this.datafeedQuery, (String)this.timeField, (long)start, (long)end)).runtimeMappings(this.runtimeMappings);
        SearchRequest searchRequest = new SearchRequest(this.datafeedIndices).source(searchSourceBuilder).indicesOptions(this.indicesOptions);
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("ml");){
            SearchResponse response = (SearchResponse)this.client.execute(TransportSearchAction.TYPE, (ActionRequest)searchRequest).actionGet();
            List buckets = ((Histogram)response.getAggregations().get(DATE_BUCKETS)).getBuckets();
            Map hashMap = Maps.newMapWithExpectedSize((int)buckets.size());
            for (Histogram.Bucket bucket : buckets) {
                long bucketTime = DatafeedDelayedDataDetector.toHistogramKeyToEpoch(bucket.getKey());
                if (bucketTime < 0L) {
                    throw new IllegalStateException("Histogram key [" + bucket.getKey() + "] cannot be converted to a timestamp");
                }
                hashMap.put(bucketTime, bucket.getDocCount());
            }
            Map map = hashMap;
            return map;
        }
    }

    private static long toHistogramKeyToEpoch(Object key) {
        if (key instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)key;
            return zdt.toInstant().toEpochMilli();
        }
        if (key instanceof Double) {
            Double doubleValue = (Double)key;
            return doubleValue.longValue();
        }
        if (key instanceof Long) {
            Long longValue = (Long)key;
            return longValue;
        }
        return -1L;
    }

    private static long calculateMissing(Map<Long, Long> indexedData, Bucket bucket) {
        return indexedData.getOrDefault(bucket.getEpoch() * 1000L, 0L) - bucket.getEventCount();
    }
}

