/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.kstest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.aggs.MlAggsHelper;
import org.elasticsearch.xpack.ml.aggs.kstest.BucketCountKSTestAggregationBuilder;

public class InternalKSTestAggregation
extends InternalAggregation {
    private final Map<String, Double> modeValues;

    public InternalKSTestAggregation(String name, Map<String, Object> metadata, Map<String, Double> modeValues) {
        super(name, metadata);
        this.modeValues = modeValues;
    }

    public InternalKSTestAggregation(StreamInput in) throws IOException {
        super(in);
        this.modeValues = in.readMap(StreamInput::readDouble);
    }

    public String getWriteableName() {
        return BucketCountKSTestAggregationBuilder.NAME.getPreferredName();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeMap(this.modeValues, StreamOutput::writeDouble);
    }

    Map<String, Double> getModeValues() {
        return this.modeValues;
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        throw new UnsupportedOperationException("Reducing a bucket_count_ks_test aggregation is not supported");
    }

    protected boolean mustReduceOnSingleInternalAgg() {
        return false;
    }

    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1) {
            return this.modeValues.get(path.get(0));
        }
        throw MlAggsHelper.invalidPathException(path, BucketCountKSTestAggregationBuilder.NAME.getPreferredName(), this.getName());
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, Double> kv : this.modeValues.entrySet()) {
            builder.field(kv.getKey(), kv.getValue());
        }
        return builder;
    }
}

