/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.AbstractItemSetMapReducer;

public abstract class ItemSetMapReduceValueSource {
    private final Field field;
    private static final Logger logger = LogManager.getLogger(ItemSetMapReduceValueSource.class);

    abstract ValueCollector getValueCollector(LeafReaderContext var1) throws IOException;

    ItemSetMapReduceValueSource(ValuesSourceConfig config, int id, ValueFormatter valueFormatter) {
        String fieldName;
        String string = fieldName = config.fieldContext() != null ? config.fieldContext().field() : null;
        if (Strings.isNullOrEmpty((String)fieldName)) {
            throw new IllegalArgumentException("scripts are not supported");
        }
        this.field = new Field(fieldName, id, config.format(), valueFormatter);
    }

    Field getField() {
        return this.field;
    }

    boolean usesOrdinals() {
        return false;
    }

    Object mapOrdinal(Object ord) throws IOException {
        return ord;
    }

    public static class Field
    implements Writeable {
        private final String name;
        private final int id;
        private final DocValueFormat format;
        private final ValueFormatter valueFormatter;

        Field(String name, int id, DocValueFormat format, ValueFormatter valueFormatter) {
            this.name = name;
            this.id = id;
            this.format = format;
            this.valueFormatter = valueFormatter;
        }

        Field(StreamInput in) throws IOException {
            this.name = in.readString();
            this.id = in.readVInt();
            this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
            this.valueFormatter = (ValueFormatter)in.readEnum(ValueFormatter.class);
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public Object formatValue(Object value) {
            return this.valueFormatter.format(this.format, value);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeVInt(this.id);
            out.writeNamedWriteable((NamedWriteable)this.format);
            out.writeEnum((Enum)this.valueFormatter);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Field that = (Field)other;
            return this.id == that.id && this.valueFormatter.ordinal() == that.valueFormatter.ordinal() && Objects.equals(this.name, that.name) && Objects.equals(this.format, that.format);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.valueFormatter, this.name, this.format});
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum ValueFormatter {
        BYTES_REF{

            @Override
            public Object format(DocValueFormat format, Object obj) {
                return format.format((BytesRef)obj);
            }
        }
        ,
        LONG{

            @Override
            public Object format(DocValueFormat format, Object obj) {
                return format.format(((Long)obj).longValue());
            }
        };


        Object format(DocValueFormat format, Object obj) {
            throw new UnsupportedOperationException();
        }
    }

    public static class NumericValueSource
    extends ItemSetMapReduceValueSource {
        private final ValuesSource.Numeric source;
        private final IncludeExclude.LongFilter longFilter;

        public NumericValueSource(ValuesSourceConfig config, int id, IncludeExclude includeExclude, AbstractItemSetMapReducer.OrdinalOptimization unusedOrdinalOptimization, LeafReaderContext unusedCtx) {
            super(config, id, ValueFormatter.LONG);
            this.source = (ValuesSource.Numeric)config.getValuesSource();
            this.longFilter = includeExclude == null ? null : includeExclude.convertToLongFilter(config.format());
        }

        @Override
        ValueCollector getValueCollector(LeafReaderContext ctx) throws IOException {
            SortedNumericDocValues values = this.source.longValues(ctx);
            Field field = this.getField();
            Tuple empty = new Tuple((Object)field, Collections.emptyList());
            return doc -> {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    if (valuesCount == 1) {
                        long v = values.nextValue();
                        if (this.longFilter == null || this.longFilter.accept(v)) {
                            return new Tuple((Object)this.getField(), Collections.singletonList(v));
                        }
                        return empty;
                    }
                    if (valuesCount == 0) {
                        return empty;
                    }
                    ArrayList<Long> objects = new ArrayList<Long>(valuesCount);
                    for (int i = 0; i < valuesCount; ++i) {
                        long v = values.nextValue();
                        if (this.longFilter != null && !this.longFilter.accept(v)) continue;
                        objects.add(v);
                    }
                    return new Tuple((Object)field, objects);
                }
                return empty;
            };
        }
    }

    public static class KeywordValueSource
    extends ItemSetMapReduceValueSource {
        private final ExecutionStrategy executionStrategy;

        public KeywordValueSource(ValuesSourceConfig config, int id, IncludeExclude includeExclude, AbstractItemSetMapReducer.OrdinalOptimization ordinalOptimization, LeafReaderContext ctx) throws IOException {
            super(config, id, ValueFormatter.BYTES_REF);
            if (AbstractItemSetMapReducer.OrdinalOptimization.GLOBAL_ORDINALS.equals((Object)ordinalOptimization) && config.getValuesSource() instanceof ValuesSource.Bytes.WithOrdinals && ((ValuesSource.Bytes.WithOrdinals)config.getValuesSource()).supportsGlobalOrdinalsMapping()) {
                logger.debug("Use ordinals for field [{}]", (Object)config.fieldContext().field());
                this.executionStrategy = new GlobalOrdinalsStrategy(this.getField(), (ValuesSource.Bytes.WithOrdinals)config.getValuesSource(), includeExclude == null ? null : includeExclude.convertToOrdinalsFilter(config.format()), ctx);
            } else {
                this.executionStrategy = new MapStrategy(this.getField(), (ValuesSource.Bytes)config.getValuesSource(), includeExclude == null ? null : includeExclude.convertToStringFilter(config.format()));
            }
        }

        @Override
        ValueCollector getValueCollector(LeafReaderContext ctx) throws IOException {
            return this.executionStrategy.getValueCollector(ctx);
        }

        @Override
        public boolean usesOrdinals() {
            return this.executionStrategy.usesOrdinals();
        }

        @Override
        Object mapOrdinal(Object ord) throws IOException {
            return this.executionStrategy.mapOrdinal(ord);
        }

        static class GlobalOrdinalsStrategy
        implements ExecutionStrategy {
            private final Field field;
            private final ValuesSource.Bytes.WithOrdinals source;
            private SortedSetDocValues docValues;
            private final LongBitSet bitSetFilter;

            GlobalOrdinalsStrategy(Field field, ValuesSource.Bytes.WithOrdinals source, IncludeExclude.OrdinalsFilter globalOrdinalsFilter, LeafReaderContext ctx) throws IOException {
                this.field = field;
                this.source = source;
                this.bitSetFilter = globalOrdinalsFilter != null ? globalOrdinalsFilter.acceptedGlobalOrdinals(source.globalOrdinalsValues(ctx)) : null;
                this.docValues = source.globalOrdinalsValues(ctx);
            }

            @Override
            public ValueCollector getValueCollector(LeafReaderContext ctx) throws IOException {
                this.docValues = this.source.globalOrdinalsValues(ctx);
                Tuple empty = new Tuple((Object)this.field, Collections.emptyList());
                SortedSetDocValues values = this.docValues;
                return doc -> {
                    if (values.advanceExact(doc)) {
                        int valuesCount = values.docValueCount();
                        if (valuesCount == 1) {
                            long v = values.nextOrd();
                            assert (v >= 0L);
                            if (this.bitSetFilter == null || this.bitSetFilter.get(v)) {
                                return new Tuple((Object)this.field, Collections.singletonList(v));
                            }
                            return empty;
                        }
                        if (valuesCount == 0) {
                            return empty;
                        }
                        ArrayList<Long> objects = new ArrayList<Long>(valuesCount);
                        for (int i = 0; i < valuesCount; ++i) {
                            long v = values.nextOrd();
                            assert (v >= 0L);
                            if (this.bitSetFilter != null && !this.bitSetFilter.get(v)) continue;
                            objects.add(v);
                        }
                        return new Tuple((Object)this.field, objects);
                    }
                    return empty;
                };
            }

            @Override
            public boolean usesOrdinals() {
                return true;
            }

            @Override
            public Object mapOrdinal(Object ord) throws IOException {
                return this.docValues.lookupOrd(((Long)ord).longValue());
            }
        }

        static interface ExecutionStrategy {
            public ValueCollector getValueCollector(LeafReaderContext var1) throws IOException;

            public Object mapOrdinal(Object var1) throws IOException;

            public boolean usesOrdinals();
        }

        static class MapStrategy
        implements ExecutionStrategy {
            private final Field field;
            private final ValuesSource.Bytes source;
            private final IncludeExclude.StringFilter stringFilter;

            MapStrategy(Field field, ValuesSource.Bytes source, IncludeExclude.StringFilter stringFilter) {
                this.field = field;
                this.source = source;
                this.stringFilter = stringFilter;
            }

            @Override
            public ValueCollector getValueCollector(LeafReaderContext ctx) throws IOException {
                SortedBinaryDocValues values = this.source.bytesValues(ctx);
                Tuple empty = new Tuple((Object)this.field, Collections.emptyList());
                return doc -> {
                    if (values.advanceExact(doc)) {
                        int valuesCount = values.docValueCount();
                        if (valuesCount == 1) {
                            BytesRef v = values.nextValue();
                            if (this.stringFilter == null || this.stringFilter.accept(v)) {
                                return new Tuple((Object)this.field, Collections.singletonList(BytesRef.deepCopyOf((BytesRef)v)));
                            }
                            return empty;
                        }
                        if (valuesCount == 0) {
                            return empty;
                        }
                        ArrayList<BytesRef> objects = new ArrayList<BytesRef>(valuesCount);
                        for (int i = 0; i < valuesCount; ++i) {
                            BytesRef v = values.nextValue();
                            if (this.stringFilter != null && !this.stringFilter.accept(v)) continue;
                            objects.add(BytesRef.deepCopyOf((BytesRef)v));
                        }
                        return new Tuple((Object)this.field, objects);
                    }
                    return empty;
                };
            }

            @Override
            public boolean usesOrdinals() {
                return false;
            }

            @Override
            public Object mapOrdinal(Object ord) {
                return ord;
            }
        }
    }

    static interface ValueCollector {
        public Tuple<Field, List<Object>> collect(int var1) throws IOException;
    }

    @FunctionalInterface
    public static interface ValueSourceSupplier {
        public ItemSetMapReduceValueSource build(ValuesSourceConfig var1, int var2, IncludeExclude var3, AbstractItemSetMapReducer.OrdinalOptimization var4, LeafReaderContext var5) throws IOException;
    }
}

