/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.ItemSetBitSet;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.TransactionStore;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.mr.ItemSetMapReduceValueSource;

public final class FrequentItemSetCollector {
    private static final Logger logger = LogManager.getLogger(FrequentItemSetCollector.class);
    private final TransactionStore transactionStore;
    private final TransactionStore.TopItemIds topItemIds;
    private final FrequentItemSetPriorityQueue queue;
    private final Map<Long, List<FrequentItemSetCandidate>> frequentItemsByCount;
    private final int size;
    private final long min;
    private int count = 0;
    private FrequentItemSetCandidate spareSet = new FrequentItemSetCandidate();

    public FrequentItemSetCollector(TransactionStore transactionStore, TransactionStore.TopItemIds topItemIds, int size, long min) {
        this.transactionStore = transactionStore;
        this.topItemIds = topItemIds;
        this.size = size;
        this.min = min;
        this.queue = new FrequentItemSetPriorityQueue(size);
        this.frequentItemsByCount = Maps.newMapWithExpectedSize((int)(size / 10));
    }

    public FrequentItemSet[] finalizeAndGetResults(List<ItemSetMapReduceValueSource.Field> fields) throws IOException {
        FrequentItemSet[] topFrequentItems = new FrequentItemSet[this.size()];
        for (int i = topFrequentItems.length - 1; i >= 0; --i) {
            topFrequentItems[i] = ((FrequentItemSetCandidate)this.queue.pop()).toFrequentItemSet(fields);
        }
        return topFrequentItems;
    }

    public int size() {
        return this.queue.size();
    }

    public long add(ItemSetBitSet itemSet, long docCount) {
        logger.trace("add itemset with {} items, doc_count {}", (Object)itemSet.cardinality(), (Object)docCount);
        if (this.queue.top() != null && this.queue.size() == this.size && (docCount < ((FrequentItemSetCandidate)this.queue.top()).getDocCount() || docCount == ((FrequentItemSetCandidate)this.queue.top()).getDocCount() && itemSet.cardinality() <= ((FrequentItemSetCandidate)this.queue.top()).size())) {
            return ((FrequentItemSetCandidate)this.queue.top()).getDocCount();
        }
        List<FrequentItemSetCandidate> setsThatShareSameDocCountBits = this.frequentItemsByCount.get(docCount);
        if (setsThatShareSameDocCountBits != null) {
            for (FrequentItemSetCandidate otherSet : setsThatShareSameDocCountBits) {
                ItemSetBitSet.SetRelation relation = itemSet.setRelation(otherSet.getItems());
                if (relation.equals((Object)ItemSetBitSet.SetRelation.SUPER_SET)) {
                    this.removeFromFrequentItemsByCount(otherSet);
                    this.queue.remove(otherSet);
                    break;
                }
                if (!relation.equals((Object)ItemSetBitSet.SetRelation.SUB_SET)) continue;
                return this.queue.size() < this.size ? this.min : ((FrequentItemSetCandidate)this.queue.top()).getDocCount();
            }
        }
        this.spareSet.reset(this.count++, itemSet, docCount);
        FrequentItemSetCandidate newItemSet = this.spareSet;
        FrequentItemSetCandidate removedItemSet = (FrequentItemSetCandidate)this.queue.insertWithOverflow(this.spareSet);
        if (removedItemSet != null) {
            this.removeFromFrequentItemsByCount(removedItemSet);
            this.spareSet = removedItemSet;
        } else {
            this.spareSet = new FrequentItemSetCandidate();
        }
        this.frequentItemsByCount.computeIfAbsent(newItemSet.getDocCount(), k -> new ArrayList()).add(newItemSet);
        return this.queue.size() < this.size ? this.min : ((FrequentItemSetCandidate)this.queue.top()).getDocCount();
    }

    private void removeFromFrequentItemsByCount(FrequentItemSetCandidate removedItemSet) {
        this.frequentItemsByCount.compute(removedItemSet.getDocCount(), (k, sets) -> {
            if (sets.size() == 1) {
                return null;
            }
            sets.remove(removedItemSet);
            return sets;
        });
    }

    Map<Long, List<FrequentItemSetCandidate>> getFrequentItemsByCount() {
        return this.frequentItemsByCount;
    }

    FrequentItemSetPriorityQueue getQueue() {
        return this.queue;
    }

    FrequentItemSetCandidate getLastSet() {
        return (FrequentItemSetCandidate)this.queue.top();
    }

    class FrequentItemSetCandidate {
        private static final int STARTBITS = 64;
        private ItemSetBitSet items = new ItemSetBitSet(64);
        private long docCount = -1L;
        private int id = -1;

        private FrequentItemSetCandidate() {
        }

        FrequentItemSet toFrequentItemSet(List<ItemSetMapReduceValueSource.Field> fields) throws IOException {
            HashMap<String, List<Object>> frequentItemsKeyValues = new HashMap<String, List<Object>>();
            int pos = this.items.nextSetBit(0);
            while (pos > 0) {
                Tuple<Integer, Object> item = FrequentItemSetCollector.this.transactionStore.getItem(FrequentItemSetCollector.this.topItemIds.getItemIdAt(pos - 1));
                assert ((Integer)item.v1() < fields.size()) : "item id exceed number of given items, did you configure eclat correctly?";
                ItemSetMapReduceValueSource.Field field = fields.get((Integer)item.v1());
                Object formattedValue = field.formatValue(item.v2());
                String fieldName = fields.get((Integer)item.v1()).getName();
                if (frequentItemsKeyValues.containsKey(fieldName)) {
                    ((List)frequentItemsKeyValues.get(fieldName)).add(formattedValue);
                } else {
                    ArrayList<Object> l = new ArrayList<Object>();
                    l.add(formattedValue);
                    frequentItemsKeyValues.put(fieldName, l);
                }
                ++pos;
                pos = this.items.nextSetBit(pos);
            }
            return new FrequentItemSet(frequentItemsKeyValues, this.docCount, (double)this.docCount / (double)FrequentItemSetCollector.this.transactionStore.getTotalTransactionCount());
        }

        long getDocCount() {
            return this.docCount;
        }

        ItemSetBitSet getItems() {
            return this.items;
        }

        int getId() {
            return this.id;
        }

        int size() {
            return this.items.cardinality();
        }

        private void reset(int id, ItemSetBitSet items, long docCount) {
            this.items.reset(items);
            this.docCount = docCount;
            this.id = id;
        }
    }

    static class FrequentItemSetPriorityQueue
    extends PriorityQueue<FrequentItemSetCandidate> {
        FrequentItemSetPriorityQueue(int size) {
            super(size);
        }

        protected boolean lessThan(FrequentItemSetCandidate a, FrequentItemSetCandidate b) {
            if (a.docCount == b.docCount) {
                return ItemSetBitSet.compare(a.items, b.items) < 0;
            }
            return a.docCount < b.docCount;
        }
    }

    public static class FrequentItemSet
    implements ToXContent,
    Writeable {
        private final Map<String, List<Object>> fields;
        private final double support;
        private long docCount;

        public FrequentItemSet(Map<String, List<Object>> fields, long docCount, double support) {
            this.fields = Collections.unmodifiableMap(fields);
            this.docCount = docCount;
            this.support = support;
        }

        public FrequentItemSet(StreamInput in) throws IOException {
            this.fields = in.readMapOfLists(StreamInput::readGenericValue);
            this.docCount = in.readVLong();
            this.support = in.readDouble();
        }

        public long getDocCount() {
            return this.docCount;
        }

        public double getSupport() {
            return this.support;
        }

        public Map<String, List<Object>> getFields() {
            return this.fields;
        }

        public void setDocCount(long docCount) {
            this.docCount = docCount;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject(Aggregation.CommonFields.KEY.getPreferredName());
            for (Map.Entry<String, List<Object>> item : this.fields.entrySet()) {
                builder.field(item.getKey(), (Iterable)item.getValue());
            }
            builder.endObject();
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            builder.field("support", this.support);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.fields, (o, v) -> o.writeCollection((Collection)v, StreamOutput::writeGenericValue));
            out.writeVLong(this.getDocCount());
            out.writeDouble(this.support);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            FrequentItemSet that = (FrequentItemSet)other;
            return this.docCount == that.docCount && this.support == that.support && this.fields.size() == that.fields.size() && this.fields.entrySet().stream().allMatch(e -> ((List)e.getValue()).equals(that.fields.get(e.getKey())));
        }

        public int hashCode() {
            return Objects.hash(this.docCount, this.support, this.fields);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{\"key\": {");
            boolean addComma = false;
            for (Map.Entry<String, List<Object>> item : this.fields.entrySet()) {
                if (addComma) {
                    sb.append(", ");
                }
                sb.append("\"" + item.getKey() + "\": {");
                sb.append(Strings.collectionToDelimitedString((Iterable)item.getValue(), (String)", "));
                sb.append("}");
                addComma = true;
            }
            sb.append("}, \"doc_count\": ");
            sb.append(this.docCount);
            sb.append(", \"support\": ");
            sb.append(this.support);
            sb.append("}");
            return sb.toString();
        }
    }
}

