/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.AbstractDiscrete;

public class Geometric
extends AbstractDiscrete {
    private final double myProbability;

    public static Geometric of(double probability) {
        return new Geometric(probability);
    }

    public Geometric() {
        this(PrimitiveMath.HALF);
    }

    public Geometric(double probability) {
        this.myProbability = probability;
    }

    @Override
    public double getExpected() {
        return PrimitiveMath.ONE / this.myProbability;
    }

    @Override
    public double getProbability(int value) {
        return this.myProbability * PrimitiveMath.POW.invoke(PrimitiveMath.ONE - this.myProbability, (double)value - PrimitiveMath.ONE);
    }

    @Override
    public double getVariance() {
        return (PrimitiveMath.ONE - this.myProbability) / (this.myProbability * this.myProbability);
    }

    @Override
    protected double generate() {
        int retVal = 1;
        while (this.random().nextDouble() + this.myProbability <= PrimitiveMath.ONE) {
            ++retVal;
        }
        return retVal;
    }
}

