/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.array.operation.AMAX;
import org.ojalgo.array.operation.COPY;
import org.ojalgo.array.operation.FillMatchingDual;
import org.ojalgo.array.operation.ModifyAll;
import org.ojalgo.array.operation.SWAP;
import org.ojalgo.array.operation.SubstituteBackwards;
import org.ojalgo.array.operation.SubstituteForwards;
import org.ojalgo.array.operation.VisitAll;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.function.special.MissingMath;
import org.ojalgo.matrix.operation.MultiplyBoth;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveFactory;
import org.ojalgo.matrix.store.Subregion2D;
import org.ojalgo.matrix.store.TransformableRegion;
import org.ojalgo.matrix.store.TransposedStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.NumberDefinition;

public final class RawStore
implements PhysicalStore<Double> {
    public static final PhysicalStore.Factory<Double, RawStore> FACTORY = new PrimitiveFactory<RawStore>(){

        @Override
        public RawStore columns(Access1D<?> ... source) {
            int nbRows = source[0].size();
            int nbCols = source.length;
            RawStore retVal = new RawStore(nbRows, nbCols);
            double[][] retValData = retVal.data;
            for (int j = 0; j < nbCols; ++j) {
                Access1D<?> tmpCol = source[j];
                for (int i = 0; i < nbRows; ++i) {
                    retValData[i][j] = tmpCol.doubleValue(i);
                }
            }
            return retVal;
        }

        @Override
        public RawStore columns(Comparable<?>[] ... source) {
            int nbRows = source[0].length;
            int nbCols = source.length;
            RawStore retVal = new RawStore(nbRows, nbCols);
            double[][] retValData = retVal.data;
            for (int j = 0; j < nbCols; ++j) {
                Comparable<?>[] tmpCol = source[j];
                for (int i = 0; i < nbRows; ++i) {
                    retValData[i][j] = NumberDefinition.doubleValue(tmpCol[i]);
                }
            }
            return retVal;
        }

        @Override
        public RawStore columns(double[] ... source) {
            int nbRows = source[0].length;
            int nbCols = source.length;
            RawStore retVal = new RawStore(nbRows, nbCols);
            double[][] retValData = retVal.data;
            for (int j = 0; j < nbCols; ++j) {
                double[] tmpCol = source[j];
                for (int i = 0; i < nbRows; ++i) {
                    retValData[i][j] = tmpCol[i];
                }
            }
            return retVal;
        }

        @Override
        public RawStore columns(List<? extends Comparable<?>> ... source) {
            int nbRows = source[0].size();
            int nbCols = source.length;
            RawStore retVal = new RawStore(nbRows, nbCols);
            double[][] retValData = retVal.data;
            for (int j = 0; j < nbCols; ++j) {
                List<Comparable<?>> tmpCol = source[j];
                for (int i = 0; i < nbRows; ++i) {
                    retValData[i][j] = NumberDefinition.doubleValue(tmpCol.get(i));
                }
            }
            return retVal;
        }

        @Override
        public RawStore copy(Access2D<?> source) {
            int nbRows = source.getRowDim();
            int nbCols = source.getColDim();
            RawStore retVal = new RawStore(nbRows, nbCols);
            for (int i = 0; i < nbRows; ++i) {
                COPY.row(source, i, retVal.data[i], 0, nbCols);
            }
            return retVal;
        }

        @Override
        public RawStore make(long rows, long columns) {
            return new RawStore(Math.toIntExact(rows), Math.toIntExact(columns));
        }

        @Override
        public RawStore rows(Access1D<?> ... source) {
            int nbRows = source.length;
            int nbCols = source[0].size();
            RawStore retVal = new RawStore(nbRows, nbCols);
            for (int i = 0; i < nbRows; ++i) {
                Access1D<?> tmpRow = source[i];
                double[] retValRow = retVal.data[i];
                for (int j = 0; j < nbCols; ++j) {
                    retValRow[j] = tmpRow.doubleValue(j);
                }
            }
            return retVal;
        }

        @Override
        public RawStore rows(Comparable<?>[] ... source) {
            int nbRows = source.length;
            int nbCols = source[0].length;
            RawStore retVal = new RawStore(nbRows, nbCols);
            for (int i = 0; i < nbRows; ++i) {
                Comparable<?>[] tmpRow = source[i];
                double[] retValRow = retVal.data[i];
                for (int j = 0; j < nbCols; ++j) {
                    retValRow[j] = NumberDefinition.doubleValue(tmpRow[j]);
                }
            }
            return retVal;
        }

        @Override
        public RawStore rows(double[] ... source) {
            int nbRows = source.length;
            int nbCols = source[0].length;
            RawStore retVal = new RawStore(nbRows, nbCols);
            for (int i = 0; i < nbRows; ++i) {
                double[] tmpRow = source[i];
                double[] retValRow = retVal.data[i];
                for (int j = 0; j < nbCols; ++j) {
                    retValRow[j] = tmpRow[j];
                }
            }
            return retVal;
        }

        @Override
        public RawStore rows(List<? extends Comparable<?>> ... source) {
            int nbRows = source.length;
            int nbCols = source[0].size();
            RawStore retVal = new RawStore(nbRows, nbCols);
            for (int i = 0; i < nbRows; ++i) {
                List<Comparable<?>> tmpRow = source[i];
                double[] retValRow = retVal.data[i];
                for (int j = 0; j < nbCols; ++j) {
                    retValRow[j] = NumberDefinition.doubleValue(tmpRow.get(j));
                }
            }
            return retVal;
        }

        @Override
        public RawStore transpose(Access2D<?> source) {
            int nbRows = source.getColDim();
            int nbCols = source.getRowDim();
            RawStore retVal = new RawStore(nbRows, nbCols);
            for (int i = 0; i < nbRows; ++i) {
                double[] retValRow = retVal.data[i];
                for (int j = 0; j < nbCols; ++j) {
                    retValRow[j] = source.doubleValue(j, i);
                }
            }
            return retVal;
        }
    };
    public final double[][] data;
    private final int myNumberOfColumns;

    public static RawStore wrap(double ... data) {
        return new RawStore(new double[][]{data}, data.length);
    }

    public static RawStore wrap(double[][] data) {
        return new RawStore(data, data[0].length);
    }

    private static RawStore convert(Access1D<?> elements, int structure) {
        if (elements instanceof RawStore) {
            return (RawStore)elements;
        }
        int nbCols = structure != 0 ? elements.size() / structure : 0;
        RawStore retVal = new RawStore(structure, nbCols);
        if (structure * nbCols != elements.size()) {
            throw new IllegalArgumentException("Array length must be a multiple of structure.");
        }
        for (int i = 0; i < structure; ++i) {
            double[] row = retVal.data[i];
            for (int j = 0; j < nbCols; ++j) {
                row[j] = elements.doubleValue(Structure2D.index(structure, i, j));
            }
        }
        return retVal;
    }

    private static double[][] extract(Access1D<?> elements, int nbRows) {
        Object retVal = null;
        if (elements instanceof RawStore && ((RawStore)elements).getRowDim() == nbRows) {
            retVal = ((RawStore)elements).data;
        } else if (elements instanceof Access2D && ((Access2D)elements).getRowDim() == nbRows) {
            retVal = ((Access2D)elements).toRawCopy2D();
        } else {
            int nbColumns = nbRows != 0 ? Math.toIntExact(elements.count() / (long)nbRows) : 0;
            retVal = new double[nbRows][];
            for (int i = 0; i < nbRows; ++i) {
                retVal[i] = new double[nbColumns];
                double[] tmpRow = retVal[i];
                for (int j = 0; j < nbColumns; ++j) {
                    tmpRow[j] = elements.doubleValue(Structure2D.index(nbRows, i, j));
                }
            }
        }
        return retVal;
    }

    private static void multiply(double[][] product, double[][] left, double[][] right) {
        int tmpRowsCount = product.length;
        int tmpComplexity = right.length;
        int tmpColsCount = right[0].length;
        double[] tmpColumn = new double[tmpComplexity];
        for (int j = 0; j < tmpColsCount; ++j) {
            for (int k = 0; k < tmpComplexity; ++k) {
                tmpColumn[k] = right[k][j];
            }
            for (int i = 0; i < tmpRowsCount; ++i) {
                double[] tmpRow = left[i];
                double tmpVal = 0.0;
                for (int k = 0; k < tmpComplexity; ++k) {
                    tmpVal += tmpRow[k] * tmpColumn[k];
                }
                product[i][j] = tmpVal;
            }
        }
    }

    static Rotation.Primitive cast(Rotation<Double> aTransf) {
        if (aTransf instanceof Rotation.Primitive) {
            return (Rotation.Primitive)aTransf;
        }
        return new Rotation.Primitive(aTransf);
    }

    RawStore(double[][] elements, int numberOfColumns) {
        this.data = elements;
        this.myNumberOfColumns = numberOfColumns;
    }

    RawStore(int m, int n) {
        this.myNumberOfColumns = n;
        this.data = new double[m][n];
    }

    @Override
    public void accept(Access2D<?> supplied) {
        int numbRows = MissingMath.toMinIntExact((long)this.data.length, supplied.countRows());
        int numbCols = MissingMath.toMinIntExact((long)this.myNumberOfColumns, supplied.countColumns());
        for (int i = 0; i < numbRows; ++i) {
            COPY.row(supplied, i, this.data[i], 0, numbCols);
        }
    }

    @Override
    public void add(long row, long col, Comparable<?> addend) {
        double[] dArray = this.data[Math.toIntExact(row)];
        int n = Math.toIntExact(col);
        dArray[n] = dArray[n] + NumberDefinition.doubleValue(addend);
    }

    @Override
    public void add(long row, long col, double addend) {
        double[] dArray = this.data[Math.toIntExact(row)];
        int n = Math.toIntExact(col);
        dArray[n] = dArray[n] + addend;
    }

    @Override
    public Double aggregateAll(Aggregator aggregator) {
        AggregatorFunction<Double> tmpVisitor = aggregator.getFunction(PrimitiveAggregator.getSet());
        this.visitAll((VoidFunction<Double>)tmpVisitor);
        return (Double)tmpVisitor.get();
    }

    @Override
    public List<Double> asList() {
        final int tmpStructure = this.data.length;
        return new AbstractList<Double>(){

            @Override
            public Double get(int index) {
                return RawStore.this.get(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure));
            }

            @Override
            public Double set(int index, Double value) {
                int tmpRow = Structure2D.row(index, tmpStructure);
                int tmpColumn = Structure2D.column(index, tmpStructure);
                Double retVal = RawStore.this.get(tmpRow, tmpColumn);
                RawStore.this.set((long)tmpRow, (long)tmpColumn, value);
                return retVal;
            }

            @Override
            public int size() {
                return (int)RawStore.this.count();
            }
        };
    }

    @Override
    public MatrixStore<Double> conjugate() {
        return this.transpose();
    }

    public RawStore copy() {
        return new RawStore(this.toRawCopy2D(), this.myNumberOfColumns);
    }

    @Override
    public long count() {
        return Structure2D.count(this.data.length, this.myNumberOfColumns);
    }

    @Override
    public long countColumns() {
        return this.myNumberOfColumns;
    }

    @Override
    public long countRows() {
        return this.data.length;
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.data[Math.toIntExact(row)][Math.toIntExact(col)];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RawStore)) {
            return false;
        }
        RawStore other = (RawStore)obj;
        return this.myNumberOfColumns == other.myNumberOfColumns && Arrays.deepEquals((Object[])this.data, (Object[])other.data);
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        SWAP.exchangeColumns(this.data, Math.toIntExact(colA), Math.toIntExact(colB));
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        SWAP.exchangeRows(this.data, Math.toIntExact(rowA), Math.toIntExact(rowB));
    }

    @Override
    public void fillAll(Double value) {
        FillMatchingDual.fillAll(this.data, value);
    }

    @Override
    public void fillAll(NullaryFunction<?> supplier) {
        FillMatchingDual.fillAll(this.data, supplier);
    }

    @Override
    public void fillByMultiplying(Access1D<Double> left, Access1D<Double> right) {
        int complexity = Math.toIntExact(left.count() / this.countRows());
        if (complexity != Math.toIntExact(right.count() / this.countColumns())) {
            ProgrammingError.throwForMultiplicationNotPossible();
        }
        double[][] rawLeft = RawStore.extract(left, this.getRowDim());
        double[][] rawRight = RawStore.extract(right, complexity);
        RawStore.multiply(this.data, rawLeft, rawRight);
    }

    @Override
    public void fillColumn(long row, long col, Double value) {
        FillMatchingDual.fillColumn(this.data, Math.toIntExact(row), Math.toIntExact(col), value);
    }

    @Override
    public void fillColumn(long row, long col, NullaryFunction<?> supplier) {
        FillMatchingDual.fillColumn(this.data, Math.toIntExact(row), Math.toIntExact(col), supplier);
    }

    @Override
    public void fillDiagonal(long row, long col, Double value) {
        FillMatchingDual.fillDiagonal(this.data, Math.toIntExact(row), Math.toIntExact(col), value);
    }

    @Override
    public void fillDiagonal(long row, long col, NullaryFunction<?> supplier) {
        FillMatchingDual.fillDiagonal(this.data, Math.toIntExact(row), Math.toIntExact(col), supplier);
    }

    @Override
    public void fillMatching(Access1D<?> source) {
        int structure = this.data.length;
        for (int i = 0; i < structure; ++i) {
            double[] rowI = this.data[i];
            for (int j = 0; j < this.myNumberOfColumns; ++j) {
                rowI[j] = source.doubleValue(Structure2D.index(structure, i, j));
            }
        }
    }

    @Override
    public void fillMatching(Access1D<Double> left, BinaryFunction<Double> function, Access1D<Double> right) {
        if (left == this) {
            double[][] tmpRight = RawStore.convert(right, (int)this.data.length).data;
            if (function == PrimitiveMath.ADD) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = this.data[i][j] + tmpRight[i][j];
                    }
                }
            } else if (function == PrimitiveMath.DIVIDE) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = this.data[i][j] / tmpRight[i][j];
                    }
                }
            } else if (function == PrimitiveMath.MULTIPLY) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = this.data[i][j] * tmpRight[i][j];
                    }
                }
            } else if (function == PrimitiveMath.SUBTRACT) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = this.data[i][j] - tmpRight[i][j];
                    }
                }
            } else {
                FillMatchingDual.fillMatching(this.data, this.data, function, tmpRight);
            }
        } else if (right == this) {
            double[][] tmpLeft = RawStore.convert(left, (int)this.data.length).data;
            if (function == PrimitiveMath.ADD) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = tmpLeft[i][j] + this.data[i][j];
                    }
                }
            } else if (function == PrimitiveMath.DIVIDE) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = tmpLeft[i][j] / this.data[i][j];
                    }
                }
            } else if (function == PrimitiveMath.MULTIPLY) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = tmpLeft[i][j] * this.data[i][j];
                    }
                }
            } else if (function == PrimitiveMath.SUBTRACT) {
                for (int i = 0; i < this.data.length; ++i) {
                    for (int j = 0; j < this.myNumberOfColumns; ++j) {
                        this.data[i][j] = tmpLeft[i][j] - this.data[i][j];
                    }
                }
            } else {
                FillMatchingDual.fillMatching(this.data, tmpLeft, function, this.data);
            }
        } else {
            FillMatchingDual.fillMatching(this.data, RawStore.convert(left, (int)this.data.length).data, function, RawStore.convert(right, (int)this.data.length).data);
        }
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        this.set(row, col, values.doubleValue(valueIndex));
    }

    @Override
    public void fillOne(long row, long col, Double value) {
        this.data[Math.toIntExact((long)row)][Math.toIntExact((long)col)] = value;
    }

    @Override
    public void fillOne(long row, long col, NullaryFunction<?> supplier) {
        this.data[Math.toIntExact((long)row)][Math.toIntExact((long)col)] = supplier.doubleValue();
    }

    @Override
    public void fillRange(long first, long limit, Double value) {
        FillMatchingDual.fillRange(this.data, (int)first, (int)limit, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<?> supplier) {
        FillMatchingDual.fillRange(this.data, (int)first, (int)limit, supplier);
    }

    @Override
    public void fillRow(long row, long col, Double value) {
        FillMatchingDual.fillRow(this.data, Math.toIntExact(row), Math.toIntExact(col), value);
    }

    @Override
    public void fillRow(long row, long col, NullaryFunction<?> supplier) {
        FillMatchingDual.fillRow(this.data, Math.toIntExact(row), Math.toIntExact(col), supplier);
    }

    @Override
    public MatrixStore<Double> get() {
        return this;
    }

    @Override
    public Double get(long row, long col) {
        return this.doubleValue(row, col);
    }

    @Override
    public int getColDim() {
        return this.myNumberOfColumns;
    }

    @Override
    public int getRowDim() {
        return this.data.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.deepHashCode((Object[])this.data);
        result = prime * result + this.myNumberOfColumns;
        return result;
    }

    @Override
    public long indexOfLargest() {
        return AMAX.invoke(this.data);
    }

    @Override
    public boolean isSmall(long row, long col, double comparedTo) {
        return PrimitiveScalar.isSmall(comparedTo, this.doubleValue(row, col));
    }

    @Override
    public void modifyAll(UnaryFunction<Double> modifier) {
        ModifyAll.modifyAll(this.data, modifier);
    }

    @Override
    public void modifyColumn(long row, long col, UnaryFunction<Double> modifier) {
        ModifyAll.modifyColumn(this.data, Math.toIntExact(row), Math.toIntExact(col), modifier);
    }

    @Override
    public void modifyDiagonal(long row, long col, UnaryFunction<Double> modifier) {
        long tmpCount = Math.min((long)this.data.length - row, (long)this.myNumberOfColumns - col);
        int tmpFirst = (int)(row + col * (long)this.data.length);
        int tmpLimit = (int)(row + tmpCount + (col + tmpCount) * (long)this.data.length);
        int tmpStep = 1 + this.data.length;
        for (int ij = tmpFirst; ij < tmpLimit; ij += tmpStep) {
            this.set((long)ij, modifier.invoke(this.doubleValue(ij)));
        }
    }

    @Override
    public void modifyMatching(Access1D<Double> left, BinaryFunction<Double> function) {
        int tmpRowDim = this.data.length;
        for (int i = 0; i < tmpRowDim; ++i) {
            double[] tmpRowI = this.data[i];
            for (int j = 0; j < this.myNumberOfColumns; ++j) {
                tmpRowI[j] = function.invoke(left.doubleValue(Structure2D.index(tmpRowDim, i, j)), tmpRowI[j]);
            }
        }
    }

    @Override
    public void modifyMatching(BinaryFunction<Double> function, Access1D<Double> right) {
        int tmpRowDim = this.data.length;
        for (int i = 0; i < tmpRowDim; ++i) {
            double[] tmpRowI = this.data[i];
            for (int j = 0; j < this.myNumberOfColumns; ++j) {
                tmpRowI[j] = function.invoke(tmpRowI[j], right.doubleValue(Structure2D.index(tmpRowDim, i, j)));
            }
        }
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<Double> modifier) {
        double tmpValue = this.doubleValue(row, col);
        tmpValue = modifier.invoke(tmpValue);
        this.set(row, col, tmpValue);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<Double> modifier) {
        for (long index = first; index < limit; ++index) {
            this.set(index, modifier.invoke(this.doubleValue(index)));
        }
    }

    @Override
    public void modifyRow(long row, long col, UnaryFunction<Double> modifier) {
        ModifyAll.modifyRow(this.data, Math.toIntExact(row), Math.toIntExact(col), modifier);
    }

    @Override
    public RawStore multiply(MatrixStore<Double> right) {
        int tmpRowDim = this.data.length;
        int tmpComplexity = this.myNumberOfColumns;
        int tmpColDim = (int)(right.count() / (long)tmpComplexity);
        RawStore retVal = new RawStore(tmpRowDim, tmpColDim);
        double[][] tmpRight = RawStore.extract(right, tmpComplexity);
        RawStore.multiply(retVal.data, this.data, tmpRight);
        return retVal;
    }

    @Override
    public Double multiplyBoth(Access1D<Double> leftAndRight) {
        PhysicalStore tmpStep1 = (PhysicalStore)FACTORY.make(1L, leftAndRight.count());
        PhysicalStore tmpStep2 = (PhysicalStore)FACTORY.make(1L, 1L);
        tmpStep1.fillByMultiplying(leftAndRight, this);
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return (Double)tmpStep2.get(0L);
    }

    @Override
    public PhysicalStore.Factory<Double, RawStore> physical() {
        return FACTORY;
    }

    @Override
    public TransformableRegion<Double> regionByColumns(int ... columns) {
        return new Subregion2D.ColumnsRegion<Double>(this, MultiplyBoth.newPrimitive64(this.data.length, this.myNumberOfColumns), columns);
    }

    @Override
    public TransformableRegion<Double> regionByLimits(int rowLimit, int columnLimit) {
        return new Subregion2D.LimitRegion<Double>(this, MultiplyBoth.newPrimitive64(this.data.length, this.myNumberOfColumns), rowLimit, columnLimit);
    }

    @Override
    public TransformableRegion<Double> regionByOffsets(int rowOffset, int columnOffset) {
        return new Subregion2D.OffsetRegion<Double>(this, MultiplyBoth.newPrimitive64(this.data.length, this.myNumberOfColumns), rowOffset, columnOffset);
    }

    @Override
    public TransformableRegion<Double> regionByRows(int ... rows) {
        return new Subregion2D.RowsRegion<Double>(this, MultiplyBoth.newPrimitive64(this.data.length, this.myNumberOfColumns), rows);
    }

    @Override
    public TransformableRegion<Double> regionByTransposing() {
        return new Subregion2D.TransposedRegion<Double>(this, MultiplyBoth.newPrimitive64(this.data.length, this.myNumberOfColumns));
    }

    @Override
    public void set(long row, long col, Comparable<?> value) {
        this.data[Math.toIntExact((long)row)][Math.toIntExact((long)col)] = NumberDefinition.doubleValue(value);
    }

    @Override
    public void set(long row, long col, double value) {
        this.data[Math.toIntExact((long)row)][Math.toIntExact((long)col)] = value;
    }

    @Override
    public Access1D<Double> sliceRow(long row) {
        return Access1D.wrap(this.data[Math.toIntExact(row)]);
    }

    @Override
    public void substituteBackwards(Access2D<Double> body, boolean unitDiagonal, boolean conjugated, boolean hermitian) {
        SubstituteBackwards.invoke(this.data, body, unitDiagonal, conjugated, hermitian);
    }

    @Override
    public void substituteForwards(Access2D<Double> body, boolean unitDiagonal, boolean conjugated, boolean identity) {
        SubstituteForwards.invoke(this.data, body, unitDiagonal, conjugated, identity);
    }

    public PrimitiveScalar toScalar(long row, long column) {
        return PrimitiveScalar.of(this.doubleValue(row, column));
    }

    public String toString() {
        return Access2D.toString(this);
    }

    @Override
    public void transformLeft(Householder<Double> transformation, int firstColumn) {
        double[][] tmpArray = this.data;
        int tmpRowDim = this.data.length;
        int tmpColDim = this.myNumberOfColumns;
        int tmpFirst = transformation.first();
        double[] tmpWorkCopy = new double[(int)transformation.count()];
        for (int j = firstColumn; j < tmpColDim; ++j) {
            double tmpScale = PrimitiveMath.ZERO;
            for (int i = tmpFirst; i < tmpRowDim; ++i) {
                tmpScale += tmpWorkCopy[i] * tmpArray[i][j];
            }
            double tmpVal2 = PrimitiveMath.ZERO;
            int tmpSize = (int)transformation.count();
            for (int i1 = transformation.first(); i1 < tmpSize; ++i1) {
                double tmpVal = transformation.doubleValue(i1);
                tmpVal2 += tmpVal * tmpVal;
                tmpWorkCopy[i1] = tmpVal;
            }
            tmpScale *= PrimitiveMath.TWO / tmpVal2;
            for (int i = tmpFirst; i < tmpRowDim; ++i) {
                double[] dArray = tmpArray[i];
                int n = j;
                dArray[n] = dArray[n] - tmpScale * tmpWorkCopy[i];
            }
        }
    }

    @Override
    public void transformLeft(Rotation<Double> transformation) {
        Rotation.Primitive tmpTransf = RawStore.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (!Double.isNaN(tmpTransf.cos) && !Double.isNaN(tmpTransf.sin)) {
                double[][] tmpArray = this.data;
                for (int j = 0; j < tmpArray[0].length; ++j) {
                    double tmpOldLow = tmpArray[tmpLow][j];
                    double tmpOldHigh = tmpArray[tmpHigh][j];
                    tmpArray[tmpLow][j] = tmpTransf.cos * tmpOldLow + tmpTransf.sin * tmpOldHigh;
                    tmpArray[tmpHigh][j] = tmpTransf.cos * tmpOldHigh - tmpTransf.sin * tmpOldLow;
                }
            } else {
                this.exchangeRows(tmpLow, tmpHigh);
            }
        } else if (!Double.isNaN(tmpTransf.cos)) {
            this.modifyRow((long)tmpLow, 0L, (UnaryFunction<Double>)PrimitiveMath.MULTIPLY.second(tmpTransf.cos));
        } else if (!Double.isNaN(tmpTransf.sin)) {
            this.modifyRow((long)tmpLow, 0L, (UnaryFunction<Double>)PrimitiveMath.DIVIDE.second(tmpTransf.sin));
        } else {
            this.modifyRow((long)tmpLow, 0L, PrimitiveMath.NEGATE);
        }
    }

    @Override
    public void transformRight(Householder<Double> transformation, int firstRow) {
        double[][] tmpArray = this.data;
        int tmpRowDim = this.data.length;
        int tmpColDim = this.myNumberOfColumns;
        int tmpFirst = transformation.first();
        double[] tmpWorkCopy = new double[(int)transformation.count()];
        for (int i = firstRow; i < tmpRowDim; ++i) {
            double tmpScale = PrimitiveMath.ZERO;
            for (int j = tmpFirst; j < tmpColDim; ++j) {
                tmpScale += tmpWorkCopy[j] * tmpArray[i][j];
            }
            double tmpVal2 = PrimitiveMath.ZERO;
            int tmpSize = (int)transformation.count();
            for (int i1 = transformation.first(); i1 < tmpSize; ++i1) {
                double tmpVal = transformation.doubleValue(i1);
                tmpVal2 += tmpVal * tmpVal;
                tmpWorkCopy[i1] = tmpVal;
            }
            tmpScale *= PrimitiveMath.TWO / tmpVal2;
            for (int j = tmpFirst; j < tmpColDim; ++j) {
                double[] dArray = tmpArray[i];
                int n = j;
                dArray[n] = dArray[n] - tmpScale * tmpWorkCopy[j];
            }
        }
    }

    @Override
    public void transformRight(Rotation<Double> transformation) {
        Rotation.Primitive tmpTransf = RawStore.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (!Double.isNaN(tmpTransf.cos) && !Double.isNaN(tmpTransf.sin)) {
                double[][] tmpArray = this.data;
                for (int i = 0; i < tmpArray.length; ++i) {
                    double tmpOldLow = tmpArray[i][tmpLow];
                    double tmpOldHigh = tmpArray[i][tmpHigh];
                    tmpArray[i][tmpLow] = tmpTransf.cos * tmpOldLow - tmpTransf.sin * tmpOldHigh;
                    tmpArray[i][tmpHigh] = tmpTransf.cos * tmpOldHigh + tmpTransf.sin * tmpOldLow;
                }
            } else {
                this.exchangeColumns(tmpLow, tmpHigh);
            }
        } else if (!Double.isNaN(tmpTransf.cos)) {
            this.modifyColumn(0L, (long)tmpHigh, (UnaryFunction<Double>)PrimitiveMath.MULTIPLY.second(tmpTransf.cos));
        } else if (!Double.isNaN(tmpTransf.sin)) {
            this.modifyColumn(0L, (long)tmpHigh, (UnaryFunction<Double>)PrimitiveMath.DIVIDE.second(tmpTransf.sin));
        } else {
            this.modifyColumn(0L, (long)tmpHigh, PrimitiveMath.NEGATE);
        }
    }

    @Override
    public MatrixStore<Double> transpose() {
        return new TransposedStore<Double>(this);
    }

    @Override
    public void visitAll(VoidFunction<Double> visitor) {
        VisitAll.visitAll(this.data, visitor);
    }

    @Override
    public void visitColumn(long row, long col, VoidFunction<Double> visitor) {
        VisitAll.visitColumn(this.data, Math.toIntExact(row), Math.toIntExact(col), visitor);
    }

    @Override
    public void visitDiagonal(long row, long col, VoidFunction<Double> visitor) {
        VisitAll.visitDiagonal(this.data, Math.toIntExact(row), Math.toIntExact(col), visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<Double> visitor) {
        VisitAll.visitRange(this.data, (int)first, (int)limit, visitor);
    }

    @Override
    public void visitRow(long row, long col, VoidFunction<Double> visitor) {
        VisitAll.visitRow(this.data, Math.toIntExact(row), Math.toIntExact(col), visitor);
    }
}

