/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.series;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.data.domain.finance.series.AlphaVantageFetcher;
import org.ojalgo.data.domain.finance.series.AlphaVantageParser;
import org.ojalgo.data.domain.finance.series.DataFetcher;
import org.ojalgo.data.domain.finance.series.DatePrice;
import org.ojalgo.data.domain.finance.series.FinanceData;
import org.ojalgo.data.domain.finance.series.IEXTradingFetcher;
import org.ojalgo.data.domain.finance.series.IEXTradingParser;
import org.ojalgo.data.domain.finance.series.SourceCache;
import org.ojalgo.data.domain.finance.series.YahooParser;
import org.ojalgo.data.domain.finance.series.YahooSession;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.netio.BasicParser;
import org.ojalgo.series.BasicSeries;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.series.primitive.CoordinatedSet;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public final class DataSource
implements FinanceData {
    private final DataFetcher myFetcher;
    private final BasicParser<? extends DatePrice> myParser;

    public static Coordinated coordinated() {
        return new Coordinated();
    }

    public static Coordinated coordinated(CalendarDateUnit resolution) {
        return new Coordinated().resolution(resolution);
    }

    public static DataSource newAlphaVantage(String symbol, CalendarDateUnit resolution, String apiKey) {
        return DataSource.newAlphaVantage(symbol, resolution, apiKey, false);
    }

    public static DataSource newAlphaVantage(String symbol, CalendarDateUnit resolution, String apiKey, boolean fullOutputSize) {
        AlphaVantageFetcher fetcher = new AlphaVantageFetcher(symbol, resolution, apiKey, fullOutputSize);
        AlphaVantageParser parser = new AlphaVantageParser();
        return new DataSource(fetcher, parser);
    }

    public static DataSource newIEXTrading(String symbol) {
        IEXTradingFetcher fetcher = new IEXTradingFetcher(symbol);
        IEXTradingParser parser = new IEXTradingParser();
        return new DataSource(fetcher, parser);
    }

    public static DataSource newYahoo(YahooSession session, String symbol, CalendarDateUnit resolution) {
        YahooSession.Fetcher fetcher = session.newFetcher(symbol, resolution);
        YahooParser parser = new YahooParser();
        return new DataSource(fetcher, parser);
    }

    DataSource(DataFetcher fetcher, BasicParser<? extends DatePrice> parser) {
        this.myFetcher = fetcher;
        this.myParser = parser;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource)obj;
        if (this.myFetcher == null ? other.myFetcher != null : !this.myFetcher.equals(other.myFetcher)) {
            return false;
        }
        return !(this.myParser == null ? other.myParser != null : !this.myParser.equals(other.myParser));
    }

    public CalendarDateSeries<Double> getCalendarDateSeries() {
        return this.getCalendarDateSeries(this.myFetcher.getResolution(), LocalTime.NOON, ZoneOffset.UTC);
    }

    public CalendarDateSeries<Double> getCalendarDateSeries(CalendarDateUnit resolution) {
        return this.getCalendarDateSeries(resolution, LocalTime.NOON, ZoneOffset.UTC);
    }

    public CalendarDateSeries<Double> getCalendarDateSeries(CalendarDateUnit resolution, LocalTime time, ZoneId zoneId) {
        CalendarDateSeries<Double> retVal = new CalendarDateSeries<Double>(resolution);
        for (DatePrice datePrice : this.getHistoricalPrices()) {
            retVal.put(CalendarDate.valueOf(datePrice.key.atTime(time).atZone(zoneId)), datePrice.getPrice());
        }
        return retVal;
    }

    public CalendarDateSeries<Double> getCalendarDateSeries(LocalTime time, ZoneId zoneId) {
        return this.getCalendarDateSeries(this.myFetcher.getResolution(), time, zoneId);
    }

    @Override
    public List<DatePrice> getHistoricalPrices() {
        try {
            ArrayList<DatePrice> retVal = new ArrayList<DatePrice>();
            this.myParser.parse(this.myFetcher.getStreamOfCSV(), row -> retVal.add((DatePrice)row));
            Collections.sort(retVal);
            return retVal;
        }
        catch (Exception cause) {
            BasicLogger.error("Fetch problem for {}!", this.myFetcher.getClass().getSimpleName());
            BasicLogger.error("Symbol & Resolution: {} & {}", this.myFetcher.getSymbol(), this.myFetcher.getResolution());
            return Collections.emptyList();
        }
    }

    public BasicSeries.NaturallySequenced<LocalDate, Double> getLocalDateSeries() {
        return this.getLocalDateSeries(this.getHistoricalPrices(), this.myFetcher.getResolution(), Primitive64Array.FACTORY);
    }

    public BasicSeries.NaturallySequenced<LocalDate, Double> getLocalDateSeries(CalendarDateUnit resolution) {
        return this.getLocalDateSeries(this.getHistoricalPrices(), resolution, Primitive64Array.FACTORY);
    }

    public BasicSeries.NaturallySequenced<LocalDate, Double> getLocalDateSeries(CalendarDateUnit resolution, DenseArray.Factory<Double> denseArrayFactory) {
        return this.getLocalDateSeries(this.getHistoricalPrices(), resolution, denseArrayFactory);
    }

    public BasicSeries.NaturallySequenced<LocalDate, Double> getLocalDateSeries(DenseArray.Factory<Double> denseArrayFactory) {
        return this.getLocalDateSeries(this.getHistoricalPrices(), this.myFetcher.getResolution(), denseArrayFactory);
    }

    @Override
    public BasicSeries<LocalDate, Double> getPriceSeries() {
        return this.getLocalDateSeries(this.getHistoricalPrices(), this.myFetcher.getResolution(), Primitive64Array.FACTORY);
    }

    @Override
    public String getSymbol() {
        return this.myFetcher.getSymbol();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myFetcher == null ? 0 : this.myFetcher.hashCode());
        result = 31 * result + (this.myParser == null ? 0 : this.myParser.hashCode());
        return result;
    }

    private BasicSeries.NaturallySequenced<LocalDate, Double> getLocalDateSeries(List<DatePrice> historicalPrices, CalendarDateUnit resolution, DenseArray.Factory<Double> denseArrayFactory) {
        BasicSeries.NaturallySequenced<LocalDate, Double> retVal = BasicSeries.LOCAL_DATE.build(denseArrayFactory);
        retVal.name(this.getSymbol());
        for (DatePrice datePrice : historicalPrices) {
            LocalDate adjusted;
            switch (resolution) {
                case MONTH: {
                    adjusted = (LocalDate)FinanceData.LAST_DAY_OF_MONTH.adjustInto(datePrice.key);
                    break;
                }
                case WEEK: {
                    adjusted = (LocalDate)FinanceData.FRIDAY_OF_WEEK.adjustInto(datePrice.key);
                    break;
                }
                default: {
                    adjusted = datePrice.key;
                }
            }
            retVal.put(adjusted, (Double)datePrice.getPrice());
        }
        return retVal;
    }

    public static final class Coordinated
    implements Supplier<CoordinatedSet<LocalDate>> {
        private final CoordinatedSet.Builder<LocalDate> myBuilder = CoordinatedSet.builder();
        private final SourceCache myCache = new SourceCache(CalendarDateUnit.DAY);
        private CalendarDateUnit myResolution = CalendarDateUnit.MONTH;
        private final YahooSession myYahooSession = new YahooSession();

        public Coordinated add(FinanceData data) {
            this.myBuilder.add(() -> this.myCache.get(data));
            return this;
        }

        public Coordinated add(FinanceData primary, FinanceData secondary) {
            this.myCache.register(primary, secondary);
            this.myBuilder.add(() -> this.myCache.get(primary));
            return this;
        }

        public Coordinated addAlphaVantage(String symbol, String apiKey) {
            this.myBuilder.add(() -> this.myCache.get(DataSource.newAlphaVantage(symbol, this.myResolution, apiKey, true)));
            return this;
        }

        public Coordinated addIEXTrading(String symbol) {
            this.myBuilder.add(() -> this.myCache.get(DataSource.newIEXTrading(symbol)));
            return this;
        }

        public Coordinated addYahoo(String symbol) {
            this.myBuilder.add(() -> this.myCache.get(DataSource.newYahoo(this.myYahooSession, symbol, this.myResolution)));
            return this;
        }

        @Override
        public CoordinatedSet<LocalDate> get() {
            return this.myBuilder.build();
        }

        public Coordinated resolution(CalendarDateUnit resolution) {
            this.myResolution = resolution;
            return this;
        }
    }
}

