/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.data.domain.finance.portfolio;

import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.data.domain.finance.portfolio.EquilibriumModel;
import org.ojalgo.data.domain.finance.portfolio.FinancePortfolio;
import org.ojalgo.data.domain.finance.portfolio.MarketEquilibrium;
import org.ojalgo.matrix.Primitive64Matrix;

public final class FixedReturnsPortfolio
extends EquilibriumModel {
    private final Primitive64Matrix myReturns;

    public FixedReturnsPortfolio(FinancePortfolio.Context aContext) {
        super(aContext);
        this.myReturns = aContext.getAssetReturns();
    }

    public FixedReturnsPortfolio(MarketEquilibrium aMarketEquilibrium, Primitive64Matrix returnsVector) {
        super(aMarketEquilibrium);
        this.myReturns = returnsVector;
    }

    private FixedReturnsPortfolio(MarketEquilibrium aMarketEquilibrium) {
        super(aMarketEquilibrium);
        this.myReturns = null;
        ProgrammingError.throwForIllegalInvocation();
    }

    public void calibrate(FinancePortfolio targetWeights) {
        this.calibrate(targetWeights.getWeights());
    }

    public void calibrate(List<? extends Comparable<?>> targetWeights) {
        this.calibrate((Primitive64Matrix)FinancePortfolio.MATRIX_FACTORY.columns(new List[]{targetWeights}), this.myReturns);
    }

    @Override
    protected Primitive64Matrix calculateAssetReturns() {
        return this.myReturns;
    }

    @Override
    protected Primitive64Matrix calculateAssetWeights() {
        return this.calculateAssetWeights(this.myReturns);
    }
}

