/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelType;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.LenientlyParsedInferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ModelPackageConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TrainedModel;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.packageloader.action.GetTrainedModelPackageConfigAction;
import org.elasticsearch.xpack.core.ml.packageloader.action.LoadTrainedModelPackageAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.MlPlatformArchitecturesUtil;
import org.elasticsearch.xpack.ml.action.TrainedModelValidator;
import org.elasticsearch.xpack.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentMetadata;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.utils.TaskRetriever;

public class TransportPutTrainedModelAction
extends TransportMasterNodeAction<PutTrainedModelAction.Request, PutTrainedModelAction.Response> {
    private static final ByteSizeValue MAX_NATIVE_DEFINITION_INDEX_SIZE = ByteSizeValue.ofGb((long)50L);
    private static final Logger logger = LogManager.getLogger(TransportPutTrainedModelAction.class);
    private final TrainedModelProvider trainedModelProvider;
    private final XPackLicenseState licenseState;
    private final NamedXContentRegistry xContentRegistry;
    private final OriginSettingClient client;
    private final Settings settings;

    @Inject
    public TransportPutTrainedModelAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, XPackLicenseState licenseState, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, TrainedModelProvider trainedModelProvider, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/ml/inference/put", transportService, clusterService, threadPool, actionFilters, PutTrainedModelAction.Request::new, indexNameExpressionResolver, PutTrainedModelAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseState = licenseState;
        this.trainedModelProvider = trainedModelProvider;
        this.xContentRegistry = xContentRegistry;
        this.client = new OriginSettingClient(client, "ml");
        this.settings = settings;
    }

    protected void masterOperation(Task task, PutTrainedModelAction.Request request, ClusterState state, ActionListener<PutTrainedModelAction.Response> finalResponseListener) {
        boolean hasModelDefinition;
        TrainedModelConfig config = request.getTrainedModelConfig();
        try {
            if (!request.isDeferDefinitionDecompression()) {
                config.ensureParsedDefinition(this.xContentRegistry);
            }
        }
        catch (IOException ex) {
            finalResponseListener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"Failed to parse definition for [{}]", (Throwable)ex, (Object[])new Object[]{config.getModelId()})));
            return;
        }
        boolean bl = hasModelDefinition = config.getModelDefinition() != null;
        if (hasModelDefinition) {
            try {
                config.getModelDefinition().getTrainedModel().validate();
            }
            catch (ElasticsearchException ex) {
                finalResponseListener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"Definition for [{}] has validation failures.", (Throwable)ex, (Object[])new Object[]{config.getModelId()})));
                return;
            }
            TrainedModelType trainedModelType = TrainedModelType.typeFromTrainedModel((TrainedModel)config.getModelDefinition().getTrainedModel());
            if (trainedModelType == null) {
                finalResponseListener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"Unknown trained model definition class [{}]", (Object[])new Object[]{config.getModelDefinition().getTrainedModel().getName()})));
                return;
            }
            if (config.getModelType() == null) {
                config = new TrainedModelConfig.Builder(config).setModelType(trainedModelType).build();
            } else if (trainedModelType != config.getModelType()) {
                finalResponseListener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"{} [{}] does not match the model definition type [{}]", (Object[])new Object[]{TrainedModelConfig.MODEL_TYPE.getPreferredName(), config.getModelType(), trainedModelType})));
                return;
            }
            if (!config.getInferenceConfig().isTargetTypeSupported(config.getModelDefinition().getTrainedModel().targetType())) {
                finalResponseListener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"Model [{}] inference config type [{}] does not support definition target type [{}]", (Object[])new Object[]{config.getModelId(), config.getInferenceConfig().getName(), config.getModelDefinition().getTrainedModel().targetType()})));
                return;
            }
            TransportVersion minCompatibilityVersion = config.getModelDefinition().getTrainedModel().getMinimalCompatibilityVersion();
            if (state.getMinTransportVersion().before((VersionId)minCompatibilityVersion)) {
                finalResponseListener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"Cannot create model [{}] while cluster upgrade is in progress.", (Object[])new Object[]{config.getModelId()})));
                return;
            }
        }
        TrainedModelConfig.Builder trainedModelConfig = new TrainedModelConfig.Builder(config).setVersion(MlConfigVersion.CURRENT).setCreateTime(Instant.now()).setCreatedBy("api_user").setLicenseLevel(License.OperationMode.PLATINUM.description());
        AtomicReference modelPackageConfigHolder = new AtomicReference();
        if (hasModelDefinition) {
            trainedModelConfig.setModelSize(config.getModelDefinition().ramBytesUsed()).setEstimatedOperations(config.getModelDefinition().getTrainedModel().estimatedNumOperations());
        } else {
            trainedModelConfig.setLocation(Optional.ofNullable(config.getModelType()).orElse(TrainedModelType.TREE_ENSEMBLE).getDefaultLocation(config.getModelId()));
        }
        if (ModelAliasMetadata.fromState(state).getModelId(trainedModelConfig.getModelId()) != null) {
            finalResponseListener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"requested model_id [{}] is the same as an existing model_alias. Model model_aliases and ids must be unique", (Object[])new Object[]{config.getModelId()})));
            return;
        }
        if (TrainedModelAssignmentMetadata.fromState(state).hasDeployment(trainedModelConfig.getModelId())) {
            finalResponseListener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)"Cannot create model [{}] the id is the same as an current model deployment", (Object[])new Object[]{config.getModelId()})));
            return;
        }
        ActionListener finalResponseAction = ActionListener.wrap(configToReturn -> finalResponseListener.onResponse((Object)new PutTrainedModelAction.Response(configToReturn)), arg_0 -> finalResponseListener.onFailure(arg_0));
        ActionListener verifyClusterAndModelArchitectures = ActionListener.wrap(configToReturn -> this.verifyMlNodesAndModelArchitectures((TrainedModelConfig)configToReturn, (Client)this.client, this.threadPool, (ActionListener<TrainedModelConfig>)finalResponseAction), arg_0 -> finalResponseListener.onFailure(arg_0));
        ActionListener finishedStoringListener = ActionListener.wrap(bool -> {
            TrainedModelConfig configToReturn = trainedModelConfig.clearDefinition().build();
            if (modelPackageConfigHolder.get() != null) {
                this.triggerModelFetchIfNecessary(configToReturn.getModelId(), (ModelPackageConfig)modelPackageConfigHolder.get(), request.isWaitForCompletion(), (ActionListener<Void>)ActionListener.wrap(downloadTriggered -> verifyClusterAndModelArchitectures.onResponse((Object)configToReturn), arg_0 -> ((ActionListener)finalResponseListener).onFailure(arg_0)));
            } else {
                finalResponseListener.onResponse((Object)new PutTrainedModelAction.Response(configToReturn));
            }
        }, arg_0 -> finalResponseListener.onFailure(arg_0));
        boolean isPackageModel = config.isPackagedModel();
        ActionListener checkStorageIndexSizeListener = ActionListener.wrap(r -> this.trainedModelProvider.storeTrainedModel(trainedModelConfig.build(), (ActionListener<Boolean>)finishedStoringListener, isPackageModel), arg_0 -> finalResponseListener.onFailure(arg_0));
        ActionListener tagsModelIdCheckListener = ActionListener.wrap(r -> {
            if (TrainedModelType.PYTORCH.equals((Object)trainedModelConfig.getModelType())) {
                this.client.admin().indices().prepareStats(new String[]{InferenceIndexConstants.nativeDefinitionStore()}).clear().setStore(true).execute(ActionListener.wrap(stats -> {
                    IndexStats indexStats = (IndexStats)stats.getIndices().get(InferenceIndexConstants.nativeDefinitionStore());
                    if (indexStats != null && indexStats.getTotal().getStore().getSizeInBytes() > MAX_NATIVE_DEFINITION_INDEX_SIZE.getBytes()) {
                        finalResponseListener.onFailure((Exception)((Object)new ElasticsearchStatusException("Native model store has exceeded the maximum acceptable size of {}, please delete older unused pytorch models", RestStatus.CONFLICT, new Object[]{MAX_NATIVE_DEFINITION_INDEX_SIZE.toString()})));
                        return;
                    }
                    checkStorageIndexSizeListener.onResponse(null);
                }, e -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                        checkStorageIndexSizeListener.onResponse(null);
                        return;
                    }
                    finalResponseListener.onFailure((Exception)((Object)new ElasticsearchStatusException("Unable to calculate stats for definition storage index [{}], please try again later", RestStatus.SERVICE_UNAVAILABLE, (Throwable)e, new Object[]{InferenceIndexConstants.nativeDefinitionStore()})));
                }));
                return;
            }
            checkStorageIndexSizeListener.onResponse(null);
        }, arg_0 -> finalResponseListener.onFailure(arg_0));
        ActionListener modelIdTagCheckListener = ActionListener.wrap(r -> this.checkTagsAgainstModelIds(request.getTrainedModelConfig().getTags(), (ActionListener<Void>)tagsModelIdCheckListener), arg_0 -> finalResponseListener.onFailure(arg_0));
        ActionListener handlePackageAndTagsListener = ActionListener.wrap(r -> {
            if (isPackageModel) {
                this.resolvePackageConfig(trainedModelConfig.getModelId(), (ActionListener<ModelPackageConfig>)ActionListener.wrap(resolvedModelPackageConfig -> {
                    try {
                        TrainedModelValidator.validatePackage(trainedModelConfig, resolvedModelPackageConfig, state);
                    }
                    catch (ValidationException e) {
                        finalResponseListener.onFailure((Exception)((Object)e));
                        return;
                    }
                    modelPackageConfigHolder.set(resolvedModelPackageConfig);
                    TransportPutTrainedModelAction.setTrainedModelConfigFieldsFromPackagedModel(trainedModelConfig, resolvedModelPackageConfig, this.xContentRegistry);
                    this.checkModelIdAgainstTags(trainedModelConfig.getModelId(), (ActionListener<Void>)modelIdTagCheckListener);
                }, arg_0 -> ((ActionListener)finalResponseListener).onFailure(arg_0)));
            } else {
                this.checkModelIdAgainstTags(trainedModelConfig.getModelId(), (ActionListener<Void>)modelIdTagCheckListener);
            }
        }, arg_0 -> finalResponseListener.onFailure(arg_0));
        TransportPutTrainedModelAction.checkForExistingTask((Client)this.client, trainedModelConfig.getModelId(), request.isWaitForCompletion(), finalResponseListener, (ActionListener<Void>)handlePackageAndTagsListener, request.timeout());
    }

    void verifyMlNodesAndModelArchitectures(final TrainedModelConfig configToReturn, Client client, ThreadPool threadPool, final ActionListener<TrainedModelConfig> configToReturnListener) {
        ActionListener<TrainedModelConfig> addWarningHeaderOnFailureListener = new ActionListener<TrainedModelConfig>(){

            public void onResponse(TrainedModelConfig config) {
                assert (Objects.equals(config, configToReturn));
                configToReturnListener.onResponse((Object)configToReturn);
            }

            public void onFailure(Exception e) {
                HeaderWarning.addWarning((String)e.getMessage(), (Object[])new Object[0]);
                configToReturnListener.onResponse((Object)configToReturn);
            }
        };
        this.callVerifyMlNodesAndModelArchitectures(configToReturn, addWarningHeaderOnFailureListener, client, threadPool);
    }

    void callVerifyMlNodesAndModelArchitectures(TrainedModelConfig configToReturn, ActionListener<TrainedModelConfig> failureListener, Client client, ThreadPool threadPool) {
        MlPlatformArchitecturesUtil.verifyMlNodesAndModelArchitectures(failureListener, (Client)client, (ExecutorService)threadPool.executor("ml_utility"), (TrainedModelConfig)configToReturn);
    }

    static void checkForExistingTask(Client client, String modelId, boolean isWaitForCompletion, ActionListener<PutTrainedModelAction.Response> sendResponseListener, ActionListener<Void> storeModelListener, TimeValue timeout) {
        TaskRetriever.getDownloadTaskInfo(client, modelId, isWaitForCompletion, timeout, () -> "Timed out waiting for model download to complete", (ActionListener<TaskInfo>)ActionListener.wrap(taskInfo -> {
            if (taskInfo != null) {
                TransportPutTrainedModelAction.getModelInformation(client, modelId, sendResponseListener);
            } else {
                storeModelListener.onResponse(null);
            }
        }, arg_0 -> sendResponseListener.onFailure(arg_0)));
    }

    private static void getExistingTaskInfo(Client client, String modelId, boolean waitForCompletion, ActionListener<TaskInfo> listener) {
        ((ListTasksRequestBuilder)client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"xpack/ml/model_import[n]"})).setDetailed(true).setWaitForCompletion(waitForCompletion).setDescriptions(new String[]{MlTasks.downloadModelTaskDescription((String)modelId)}).execute(ActionListener.wrap(response -> {
            List tasks = response.getTasks();
            if (tasks.size() > 0) {
                listener.onResponse((Object)((TaskInfo)tasks.get(0)));
            } else {
                listener.onResponse(null);
            }
        }, e -> listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Unable to retrieve task information for model id [{}]", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[]{modelId})))));
    }

    private static void getModelInformation(Client client, String modelId, ActionListener<PutTrainedModelAction.Response> listener) {
        client.execute((ActionType)GetTrainedModelsAction.INSTANCE, (ActionRequest)new GetTrainedModelsAction.Request(modelId), ActionListener.wrap(models -> {
            if (models.getResources().results().size() == 0) {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("No model information found for a concurrent create model execution for model id [{}]", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{modelId})));
            } else {
                listener.onResponse((Object)new PutTrainedModelAction.Response((TrainedModelConfig)models.getResources().results().get(0)));
            }
        }, e -> listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Unable to retrieve model information for a concurrent create model execution for model id [{}]", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)e, new Object[]{modelId})))));
    }

    private void triggerModelFetchIfNecessary(String modelId, ModelPackageConfig modelPackageConfig, boolean waitForCompletion, ActionListener<Void> listener) {
        this.client.execute((ActionType)LoadTrainedModelPackageAction.INSTANCE, (ActionRequest)new LoadTrainedModelPackageAction.Request(modelId, modelPackageConfig, waitForCompletion), ActionListener.wrap(ack -> {
            if (waitForCompletion) {
                listener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
        if (!waitForCompletion) {
            listener.onResponse(null);
        }
    }

    private void resolvePackageConfig(String modelId, ActionListener<ModelPackageConfig> listener) {
        this.client.execute((ActionType)GetTrainedModelPackageConfigAction.INSTANCE, (ActionRequest)new GetTrainedModelPackageConfigAction.Request(modelId.substring(1)), ActionListener.wrap(packageConfig -> listener.onResponse((Object)packageConfig.getModelPackageConfig()), arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkModelIdAgainstTags(String modelId, ActionListener<Void> listener) {
        ConstantScoreQueryBuilder builder = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TrainedModelConfig.TAGS.getPreferredName(), (String)modelId)));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)builder).size(0).trackTotalHitsUpTo(1);
        SearchRequest searchRequest = new SearchRequest(new String[]{".ml-inference-*"}).source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.getHits().getTotalHits().value > 0L) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"The provided model_id {0} must not match existing tags.", (Object[])new Object[]{modelId}), (Object[])new Object[0])));
                return;
            }
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((OriginSettingClient)this.client).search(arg_0, arg_1));
    }

    private void checkTagsAgainstModelIds(List<String> tags, ActionListener<Void> listener) {
        if (tags.isEmpty()) {
            listener.onResponse(null);
            return;
        }
        ConstantScoreQueryBuilder builder = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)TrainedModelConfig.MODEL_ID.getPreferredName(), tags)));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)builder).size(0).trackTotalHitsUpTo(1);
        SearchRequest searchRequest = new SearchRequest(new String[]{".ml-inference-*"}).source(sourceBuilder);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"ml", (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.getHits().getTotalHits().value > 0L) {
                listener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"The provided tags {0} must not match existing model_ids.", (Object[])new Object[]{tags}), (Object[])new Object[0])));
                return;
            }
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((OriginSettingClient)this.client).search(arg_0, arg_1));
    }

    protected ClusterBlockException checkBlock(PutTrainedModelAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void doExecute(Task task, PutTrainedModelAction.Request request, ActionListener<PutTrainedModelAction.Response> listener) {
        if (MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            super.doExecute(task, (MasterNodeRequest)request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }

    static void setTrainedModelConfigFieldsFromPackagedModel(TrainedModelConfig.Builder trainedModelConfig, ModelPackageConfig resolvedModelPackageConfig, NamedXContentRegistry xContentRegistry) throws IOException {
        trainedModelConfig.setDescription(resolvedModelPackageConfig.getDescription());
        trainedModelConfig.setModelType(TrainedModelType.fromString((String)resolvedModelPackageConfig.getModelType()));
        trainedModelConfig.setPlatformArchitecture(resolvedModelPackageConfig.getPlatformArchitecture());
        trainedModelConfig.setMetadata(resolvedModelPackageConfig.getMetadata());
        trainedModelConfig.setInferenceConfig(TransportPutTrainedModelAction.parseInferenceConfigFromModelPackage(resolvedModelPackageConfig.getInferenceConfigSource(), xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE));
        trainedModelConfig.setTags(resolvedModelPackageConfig.getTags());
        trainedModelConfig.setPrefixStrings(resolvedModelPackageConfig.getPrefixStrings());
        trainedModelConfig.setModelPackageConfig(new ModelPackageConfig.Builder(resolvedModelPackageConfig).resetPackageOnlyFields().build());
        trainedModelConfig.setLocation(trainedModelConfig.getModelType().getDefaultLocation(trainedModelConfig.getModelId()));
    }

    static InferenceConfig parseInferenceConfigFromModelPackage(Map<String, Object> source, NamedXContentRegistry namedXContentRegistry, DeprecationHandler deprecationHandler) throws IOException {
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(source);
        XContentParser sourceParser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY.withRegistry(namedXContentRegistry).withDeprecationHandler(deprecationHandler), (InputStream)BytesReference.bytes((XContentBuilder)xContentBuilder).streamInput());
        XContentParser.Token token = sourceParser.nextToken();
        assert (token == XContentParser.Token.START_OBJECT);
        token = sourceParser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        String currentName = sourceParser.currentName();
        InferenceConfig inferenceConfig = (InferenceConfig)sourceParser.namedObject(LenientlyParsedInferenceConfig.class, currentName, null);
        token = sourceParser.nextToken();
        assert (token == XContentParser.Token.END_OBJECT);
        return inferenceConfig;
    }
}

