/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cli;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.core.SuppressForbidden;

public abstract class Command
implements Closeable {
    protected final String description;
    protected final OptionParser parser = new OptionParser();
    private final OptionSpec<Void> helpOption = this.parser.acceptsAll(Arrays.asList("h", "help"), "Show help").forHelp();
    private final OptionSpec<Void> silentOption = this.parser.acceptsAll(Arrays.asList("s", "silent"), "Show minimal output");
    private final OptionSpec<Void> verboseOption = this.parser.acceptsAll(Arrays.asList("v", "verbose"), "Show verbose output").availableUnless(this.silentOption, new OptionSpec[0]);

    public Command(String description) {
        this.description = description;
    }

    public final int main(String[] args, Terminal terminal, ProcessInfo processInfo) throws Exception {
        try {
            this.mainWithoutErrorHandling(args, terminal, processInfo);
        }
        catch (OptionException e) {
            this.printHelp(terminal, true);
            terminal.errorPrintln(Terminal.Verbosity.SILENT, "ERROR: " + e.getMessage());
            return 64;
        }
        catch (UserException e) {
            if (e.exitCode == 64) {
                this.printHelp(terminal, true);
            }
            this.printUserException(terminal, e);
            return e.exitCode;
        }
        return 0;
    }

    protected void mainWithoutErrorHandling(String[] args, Terminal terminal, ProcessInfo processInfo) throws Exception {
        OptionSet options = this.parseOptions(args);
        if (options.has(this.helpOption)) {
            this.printHelp(terminal, false);
            return;
        }
        if (options.has(this.silentOption)) {
            terminal.setVerbosity(Terminal.Verbosity.SILENT);
        } else if (options.has(this.verboseOption)) {
            terminal.setVerbosity(Terminal.Verbosity.VERBOSE);
        } else {
            terminal.setVerbosity(Terminal.Verbosity.NORMAL);
        }
        this.execute(terminal, options, processInfo);
    }

    public OptionSet parseOptions(String[] args) {
        return this.parser.parse(args);
    }

    private void printHelp(Terminal terminal, boolean toStdError) throws IOException {
        if (toStdError) {
            terminal.errorPrintln(this.description);
            terminal.errorPrintln("");
            this.parser.printHelpOn((Writer)terminal.getErrorWriter());
        } else {
            terminal.println(this.description);
            terminal.println("");
            this.printAdditionalHelp(terminal);
            this.parser.printHelpOn((Writer)terminal.getWriter());
        }
    }

    protected void printAdditionalHelp(Terminal terminal) {
    }

    protected void printUserException(Terminal terminal, UserException e) {
        if (e.getMessage() != null) {
            terminal.errorPrintln("");
            terminal.errorPrintln(Terminal.Verbosity.SILENT, "ERROR: " + e.getMessage() + ", with exit code " + e.exitCode);
        }
    }

    @SuppressForbidden(reason="Allowed to exit explicitly from #main()")
    protected static void exit(int status) {
        System.exit(status);
    }

    protected abstract void execute(Terminal var1, OptionSet var2, ProcessInfo var3) throws Exception;

    @Override
    public void close() throws IOException {
    }
}

