/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.LocalSourceOperator;
import org.elasticsearch.compute.operator.SourceOperator;

public class RowOperator
extends LocalSourceOperator {
    private final List<Object> objects;

    public RowOperator(BlockFactory blockFactory, List<Object> objects) {
        super(blockFactory, () -> objects);
        this.objects = objects;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("objects=").append(this.objects);
        sb.append("]");
        return sb.toString();
    }

    public record RowOperatorFactory(List<Object> objects) implements SourceOperator.SourceOperatorFactory
    {
        @Override
        public SourceOperator get(DriverContext driverContext) {
            return new RowOperator(BlockFactory.getNonBreakingInstance(), this.objects);
        }

        @Override
        public String describe() {
            return "RowOperator[objects = " + this.objects.stream().map(Objects::toString).collect(Collectors.joining(",")) + "]";
        }
    }
}

