/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class MvExpandOperator
implements Operator {
    private static final Logger logger = LogManager.getLogger(MvExpandOperator.class);
    private final int channel;
    private final int pageSize;
    private int noops;
    private Page prev;
    private boolean prevCompleted;
    private boolean finished = false;
    private Block expandingBlock;
    private Block expandedBlock;
    private int nextPositionToProcess = 0;
    private int nextMvToProcess = 0;
    private int nextItemOnExpanded = 0;
    private int pagesIn;
    private int pagesOut;

    public MvExpandOperator(int channel, int pageSize) {
        this.channel = channel;
        this.pageSize = pageSize;
        assert (pageSize > 0);
    }

    @Override
    public final Page getOutput() {
        if (this.prev == null) {
            return null;
        }
        ++this.pagesOut;
        if (this.expandedBlock == null) {
            logger.trace("starting {}", new Object[]{this.prev});
            this.expandingBlock = this.prev.getBlock(this.channel);
            this.expandedBlock = this.expandingBlock.expand();
            if (this.expandedBlock == this.expandingBlock) {
                logger.trace("expanded to same");
                ++this.noops;
                Page result = this.prev;
                this.prev = null;
                this.releaseAndClearState();
                return result;
            }
            if (this.prev.getBlockCount() == 1) {
                logger.trace("single block output");
                assert (this.channel == 0);
                Page result = new Page(this.expandedBlock);
                this.expandedBlock = null;
                this.releaseAndClearState();
                return result;
            }
        }
        logger.trace("slicing");
        return this.sliceExpandedIntoPages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page sliceExpandedIntoPages() {
        this.prevCompleted = false;
        int[] duplicateFilter = this.nextDuplicateExpandingFilter();
        Releasable[] result = new Block[this.prev.getBlockCount()];
        boolean success = false;
        try {
            int[] expandedMask = new int[duplicateFilter.length];
            for (int i = 0; i < expandedMask.length; ++i) {
                expandedMask[i] = i + this.nextItemOnExpanded;
            }
            this.nextItemOnExpanded += expandedMask.length;
            for (int b = 0; b < result.length; ++b) {
                result[b] = b == this.channel ? this.expandedBlock.filter(expandedMask) : this.prev.getBlock(b).filter(duplicateFilter);
            }
            success = true;
        }
        finally {
            if (!success) {
                Releasables.closeExpectNoException((Releasable[])result);
            }
        }
        if (this.nextItemOnExpanded == this.expandedBlock.getPositionCount()) {
            this.nextItemOnExpanded = 0;
        }
        if (this.prevCompleted) {
            this.releaseAndClearState();
        }
        return new Page((Block[])result);
    }

    private int[] nextDuplicateExpandingFilter() {
        int[] duplicateFilter = new int[Math.min(this.pageSize, this.expandedBlock.getPositionCount() - this.nextPositionToProcess)];
        int n = 0;
        do {
            int count;
            int positions = (count = this.expandingBlock.getValueCount(this.nextPositionToProcess)) == 0 ? 1 : count;
            int toAdd = Math.min(this.pageSize - n, positions - this.nextMvToProcess);
            Arrays.fill(duplicateFilter, n, n + toAdd, this.nextPositionToProcess);
            if ((n += toAdd) == this.pageSize) {
                if (this.nextMvToProcess + toAdd == positions) {
                    this.nextMvToProcess = 0;
                    ++this.nextPositionToProcess;
                    if (this.nextPositionToProcess == this.expandingBlock.getPositionCount()) {
                        this.nextPositionToProcess = 0;
                        this.prevCompleted = true;
                    }
                } else {
                    this.nextMvToProcess += toAdd;
                }
                return duplicateFilter;
            }
            this.nextMvToProcess = 0;
            ++this.nextPositionToProcess;
        } while (this.nextPositionToProcess != this.expandingBlock.getPositionCount());
        this.nextPositionToProcess = 0;
        this.nextMvToProcess = 0;
        this.prevCompleted = true;
        return n < this.pageSize ? Arrays.copyOfRange(duplicateFilter, 0, n) : duplicateFilter;
    }

    private void releaseAndClearState() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{() -> {
            if (this.prev != null) {
                this.prev.releaseBlocks();
                this.prev = null;
            }
        }, this.expandedBlock});
        this.expandingBlock = null;
        this.expandedBlock = null;
    }

    @Override
    public final boolean needsInput() {
        return this.prev == null && !this.finished;
    }

    @Override
    public final void addInput(Page page) {
        assert (this.prev == null) : "has pending input page";
        this.prev = page;
        this.expandingBlock = this.prev.getBlock(this.channel);
        ++this.pagesIn;
    }

    @Override
    public final void finish() {
        this.finished = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finished && this.prev == null;
    }

    @Override
    public final Status status() {
        return new Status(this.pagesIn, this.pagesOut, this.noops);
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{() -> {
            if (this.prev != null) {
                this.prev.releaseBlocks();
            }
        }, this.expandedBlock});
    }

    public String toString() {
        return "MvExpandOperator[channel=" + this.channel + "]";
    }

    public static final class Status
    implements Operator.Status {
        private final int pagesIn;
        private final int pagesOut;
        private final int noops;
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "mv_expand", Status::new);

        Status(int pagesIn, int pagesOut, int noops) {
            this.pagesIn = pagesIn;
            this.pagesOut = pagesOut;
            this.noops = noops;
        }

        Status(StreamInput in) throws IOException {
            this.pagesIn = in.readVInt();
            this.pagesOut = in.readVInt();
            this.noops = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.pagesIn);
            out.writeVInt(this.pagesOut);
            out.writeVInt(this.noops);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("pages_in", this.pagesIn);
            builder.field("pages_out", this.pagesOut);
            builder.field("noops", this.noops);
            return builder.endObject();
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int noops() {
            return this.noops;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.noops == status.noops && this.pagesIn == status.pagesIn && this.pagesOut == status.pagesOut;
        }

        public int pagesIn() {
            return this.pagesIn;
        }

        public int pagesOut() {
            return this.pagesOut;
        }

        public int hashCode() {
            return Objects.hash(this.noops, this.pagesIn, this.pagesOut);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public record Factory(int channel, int blockSize) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new MvExpandOperator(this.channel, this.blockSize);
        }

        @Override
        public String describe() {
            return "MvExpandOperator[channel=" + this.channel + "]";
        }
    }
}

