/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.operator.BatchEncoder;
import org.elasticsearch.compute.operator.MultivalueDedupe;

public class MultivalueDedupeDouble {
    private static final int ALWAYS_COPY_MISSING = 110;
    private final DoubleBlock block;
    private double[] work = new double[ArrayUtil.oversize((int)2, (int)8)];
    private int w;

    public MultivalueDedupeDouble(DoubleBlock block) {
        this.block = block;
    }

    public DoubleBlock dedupeToBlockAdaptive(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (DoubleBlock.Builder builder = DoubleBlock.newBlockBuilder(this.block.getPositionCount(), blockFactory);){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendDouble(this.block.getDouble(first));
                        continue block9;
                    }
                    default: {
                        if (count < 110) {
                            this.copyMissing(first, count);
                            this.writeUniquedWork(builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.writeSortedWork(builder);
                    }
                }
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    public DoubleBlock dedupeToBlockUsingCopyAndSort(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (DoubleBlock.Builder builder = DoubleBlock.newBlockBuilder(this.block.getPositionCount(), blockFactory);){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendDouble(this.block.getDouble(first));
                        continue block9;
                    }
                    default: {
                        this.copyAndSort(first, count);
                        this.writeSortedWork(builder);
                    }
                }
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    public DoubleBlock dedupeToBlockUsingCopyMissing(BlockFactory blockFactory) {
        if (this.block.mvDeduplicated()) {
            this.block.incRef();
            return this.block;
        }
        try (DoubleBlock.Builder builder = DoubleBlock.newBlockBuilder(this.block.getPositionCount(), blockFactory);){
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        builder.appendDouble(this.block.getDouble(first));
                        continue block9;
                    }
                    default: {
                        this.copyMissing(first, count);
                        this.writeUniquedWork(builder);
                    }
                }
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    public MultivalueDedupe.HashResult hash(BlockFactory blockFactory, LongHash hash) {
        try (IntBlock.Builder builder = blockFactory.newIntBlockBuilder(this.block.getPositionCount());){
            boolean sawNull = false;
            block9: for (int p = 0; p < this.block.getPositionCount(); ++p) {
                int count = this.block.getValueCount(p);
                int first = this.block.getFirstValueIndex(p);
                switch (count) {
                    case 0: {
                        sawNull = true;
                        builder.appendInt(0);
                        continue block9;
                    }
                    case 1: {
                        double v = this.block.getDouble(first);
                        this.hash(builder, hash, v);
                        continue block9;
                    }
                    default: {
                        if (count < 110) {
                            this.copyMissing(first, count);
                            this.hashUniquedWork(hash, builder);
                            continue block9;
                        }
                        this.copyAndSort(first, count);
                        this.hashSortedWork(hash, builder);
                    }
                }
            }
            MultivalueDedupe.HashResult hashResult = new MultivalueDedupe.HashResult(builder.build(), sawNull);
            return hashResult;
        }
    }

    public BatchEncoder batchEncoder(int batchSize) {
        return new BatchEncoder.Doubles(batchSize){

            @Override
            protected void readNextBatch() {
                int position = this.firstPosition();
                if (MultivalueDedupeDouble.this.w > 0) {
                    this.ensureCapacity(MultivalueDedupeDouble.this.w);
                    this.startPosition();
                    MultivalueDedupeDouble.this.encodeUniquedWork(this);
                    this.endPosition();
                    ++position;
                }
                while (position < MultivalueDedupeDouble.this.block.getPositionCount()) {
                    int count = MultivalueDedupeDouble.this.block.getValueCount(position);
                    int first = MultivalueDedupeDouble.this.block.getFirstValueIndex(position);
                    switch (count) {
                        case 0: {
                            this.encodeNull();
                            break;
                        }
                        case 1: {
                            double v = MultivalueDedupeDouble.this.block.getDouble(first);
                            if (this.hasCapacity(1)) {
                                this.startPosition();
                                this.encode(v);
                                this.endPosition();
                                break;
                            }
                            MultivalueDedupeDouble.this.work[0] = v;
                            MultivalueDedupeDouble.this.w = 1;
                            return;
                        }
                        default: {
                            if (count < 110) {
                                MultivalueDedupeDouble.this.copyMissing(first, count);
                            } else {
                                MultivalueDedupeDouble.this.copyAndSort(first, count);
                                MultivalueDedupeDouble.this.convertSortedWorkToUnique();
                            }
                            if (this.hasCapacity(MultivalueDedupeDouble.this.w)) {
                                this.startPosition();
                                MultivalueDedupeDouble.this.encodeUniquedWork(this);
                                this.endPosition();
                                break;
                            }
                            return;
                        }
                    }
                    ++position;
                }
            }
        };
    }

    private void copyAndSort(int first, int count) {
        this.grow(count);
        int end = first + count;
        this.w = 0;
        for (int i = first; i < end; ++i) {
            this.work[this.w++] = this.block.getDouble(i);
        }
        Arrays.sort(this.work, 0, this.w);
    }

    private void copyMissing(int first, int count) {
        this.grow(count);
        int end = first + count;
        this.work[0] = this.block.getDouble(first);
        this.w = 1;
        block0: for (int i = first + 1; i < end; ++i) {
            double v = this.block.getDouble(i);
            for (int j = 0; j < this.w; ++j) {
                if (v == this.work[j]) continue block0;
            }
            this.work[this.w++] = v;
        }
    }

    private void writeUniquedWork(DoubleBlock.Builder builder) {
        if (this.w == 1) {
            builder.appendDouble(this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            builder.appendDouble(this.work[i]);
        }
        builder.endPositionEntry();
    }

    private void writeSortedWork(DoubleBlock.Builder builder) {
        if (this.w == 1) {
            builder.appendDouble(this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        double prev = this.work[0];
        builder.appendDouble(prev);
        for (int i = 1; i < this.w; ++i) {
            if (prev == this.work[i]) continue;
            prev = this.work[i];
            builder.appendDouble(prev);
        }
        builder.endPositionEntry();
    }

    private void hashUniquedWork(LongHash hash, IntBlock.Builder builder) {
        if (this.w == 1) {
            this.hash(builder, hash, this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        for (int i = 0; i < this.w; ++i) {
            this.hash(builder, hash, this.work[i]);
        }
        builder.endPositionEntry();
    }

    private void hashSortedWork(LongHash hash, IntBlock.Builder builder) {
        if (this.w == 1) {
            this.hash(builder, hash, this.work[0]);
            return;
        }
        builder.beginPositionEntry();
        double prev = this.work[0];
        this.hash(builder, hash, prev);
        for (int i = 1; i < this.w; ++i) {
            if (prev == this.work[i]) continue;
            prev = this.work[i];
            this.hash(builder, hash, prev);
        }
        builder.endPositionEntry();
    }

    private void encodeUniquedWork(BatchEncoder.Doubles encoder) {
        for (int i = 0; i < this.w; ++i) {
            encoder.encode(this.work[i]);
        }
    }

    private void convertSortedWorkToUnique() {
        double prev = this.work[0];
        int end = this.w;
        this.w = 1;
        for (int i = 1; i < end; ++i) {
            if (prev == this.work[i]) continue;
            prev = this.work[i];
            this.work[this.w++] = prev;
        }
    }

    private void grow(int size) {
        this.work = ArrayUtil.grow((double[])this.work, (int)size);
    }

    private void hash(IntBlock.Builder builder, LongHash hash, double v) {
        builder.appendInt(Math.toIntExact(BlockHash.hashOrdToGroupNullReserved(hash.add(Double.doubleToLongBits(v)))));
    }
}

