/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.function.Supplier;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class ColumnExtractOperator
extends AbstractPageMappingOperator {
    private final ElementType[] types;
    private final EvalOperator.ExpressionEvaluator inputEvaluator;
    private final Evaluator evaluator;
    private final DriverContext driverContext;

    public ColumnExtractOperator(ElementType[] types, EvalOperator.ExpressionEvaluator inputEvaluator, Evaluator evaluator, DriverContext driverContext) {
        this.types = types;
        this.inputEvaluator = inputEvaluator;
        this.evaluator = evaluator;
        this.driverContext = driverContext;
    }

    @Override
    protected Page process(Page page) {
        int rowsCount = page.getPositionCount();
        Releasable[] blockBuilders = new Block.Builder[this.types.length];
        try {
            Page page2;
            block14: {
                for (int i = 0; i < this.types.length; ++i) {
                    blockBuilders[i] = this.types[i].newBlockBuilder(rowsCount, this.driverContext.blockFactory());
                }
                BytesRefBlock input = (BytesRefBlock)this.inputEvaluator.eval(page);
                try {
                    int i;
                    BytesRef spare = new BytesRef();
                    for (int row = 0; row < rowsCount; ++row) {
                        if (input.isNull(row)) {
                            for (i = 0; i < blockBuilders.length; ++i) {
                                blockBuilders[i].appendNull();
                            }
                            continue;
                        }
                        this.evaluator.computeRow(input, row, (Block.Builder[])blockBuilders, spare);
                    }
                    Block[] blocks = new Block[blockBuilders.length];
                    for (i = 0; i < blockBuilders.length; ++i) {
                        blocks[i] = blockBuilders[i].build();
                    }
                    page2 = page.appendBlocks(blocks);
                    if (input == null) break block14;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return page2;
        }
        finally {
            Releasables.closeExpectNoException((Releasable[])blockBuilders);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("evaluator=");
        sb.append(this.evaluator.toString());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.inputEvaluator, () -> super.close()});
    }

    public static interface Evaluator {
        public void computeRow(BytesRefBlock var1, int var2, Block.Builder[] var3, BytesRef var4);
    }

    public record Factory(ElementType[] types, EvalOperator.ExpressionEvaluator.Factory inputEvalSupplier, Supplier<Evaluator> evaluatorSupplier) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new ColumnExtractOperator(this.types, this.inputEvalSupplier.get(driverContext), this.evaluatorSupplier.get(), driverContext);
        }

        @Override
        public String describe() {
            return "ColumnExtractOperator[evaluator=" + this.evaluatorSupplier.get() + "]";
        }
    }
}

