/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.core.Releasable;

public class BreakingBytesRefBuilder
implements Accountable,
Releasable {
    static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(BreakingBytesRefBuilder.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRef.class);
    private final BytesRef bytes;
    private final CircuitBreaker breaker;
    private final String label;

    public BreakingBytesRefBuilder(CircuitBreaker breaker, String label) {
        breaker.addEstimateBytesAndMaybeBreak(SHALLOW_SIZE + RamUsageEstimator.sizeOf((byte[])BytesRef.EMPTY_BYTES), label);
        this.bytes = new BytesRef();
        this.breaker = breaker;
        this.label = label;
    }

    public void grow(int capacity) {
        int oldLength = this.bytes.bytes.length;
        if (oldLength > capacity) {
            return;
        }
        int newLength = ArrayUtil.oversize((int)capacity, (int)1);
        this.breaker.addEstimateBytesAndMaybeBreak(RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + newLength)), this.label);
        this.bytes.bytes = ArrayUtil.growExact((byte[])this.bytes.bytes, (int)newLength);
        this.breaker.addWithoutBreaking(-RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + oldLength)));
    }

    public byte[] bytes() {
        return this.bytes.bytes;
    }

    public int length() {
        return this.bytes.length;
    }

    public void setLength(int length) {
        this.bytes.length = length;
    }

    public void append(byte b) {
        this.grow(this.bytes.length + 1);
        this.bytes.bytes[this.bytes.length++] = b;
    }

    public void append(byte[] b, int off, int len) {
        this.grow(this.bytes.length + len);
        System.arraycopy(b, off, this.bytes.bytes, this.bytes.length, len);
        this.bytes.length += len;
    }

    public void append(BytesRef bytes) {
        this.append(bytes.bytes, bytes.offset, bytes.length);
    }

    public void clear() {
        this.bytes.length = 0;
    }

    public BytesRef bytesRefView() {
        assert (this.bytes.offset == 0);
        return this.bytes;
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOf((byte[])this.bytes.bytes);
    }

    public void close() {
        this.breaker.addWithoutBreaking(-this.ramBytesUsed());
    }
}

