/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.SingletonOrdinalsBuilder;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockLoaderStoredFieldsFromLeafLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ValuesSourceReaderOperator
extends AbstractPageMappingOperator {
    static final int SEQUENTIAL_BOUNDARY = 10;
    private final List<FieldWork> fields;
    private final List<ShardContext> shardContexts;
    private final int docChannel;
    private final BlockFactory blockFactory;
    private final Map<String, Integer> readersBuilt = new TreeMap<String, Integer>();

    public ValuesSourceReaderOperator(BlockFactory blockFactory, List<FieldInfo> fields, List<ShardContext> shardContexts, int docChannel) {
        this.fields = fields.stream().map(f -> new FieldWork((FieldInfo)f)).toList();
        this.shardContexts = shardContexts;
        this.docChannel = docChannel;
        this.blockFactory = blockFactory;
    }

    @Override
    protected Page process(Page page) {
        DocVector docVector = ((DocBlock)page.getBlock(this.docChannel)).asVector();
        Releasable[] blocks = new Block[this.fields.size()];
        boolean success = false;
        try {
            if (docVector.singleSegmentNonDecreasing()) {
                this.loadFromSingleLeaf((Block[])blocks, docVector);
            } else {
                this.loadFromManyLeaves((Block[])blocks, docVector);
            }
            success = true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!success) {
                Releasables.closeExpectNoException((Releasable[])blocks);
            }
        }
        return page.appendBlocks((Block[])blocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromSingleLeaf(Block[] blocks, DocVector docVector) throws IOException {
        int shard = docVector.shards().getInt(0);
        int segment = docVector.segments().getInt(0);
        int firstDoc = docVector.docs().getInt(0);
        final IntVector docs = docVector.docs();
        BlockLoader.Docs loaderDocs = new BlockLoader.Docs(){

            public int count() {
                return docs.getPositionCount();
            }

            public int get(int i) {
                return docs.getInt(i);
            }
        };
        StoredFieldsSpec storedFieldsSpec = StoredFieldsSpec.NO_REQUIREMENTS;
        ArrayList<RowStrideReaderWork> rowStrideReaders = new ArrayList<RowStrideReaderWork>(this.fields.size());
        ComputeBlockLoaderFactory loaderBlockFactory = new ComputeBlockLoaderFactory(this.blockFactory, docs.getPositionCount());
        try {
            StoredFieldLoader storedFieldLoader;
            for (int b = 0; b < this.fields.size(); ++b) {
                FieldWork field = this.fields.get(b);
                BlockLoader.ColumnAtATimeReader columnAtATime = field.columnAtATime.reader(shard, segment, firstDoc);
                if (columnAtATime != null) {
                    blocks[b] = (Block)columnAtATime.read((BlockLoader.BlockFactory)loaderBlockFactory, loaderDocs);
                    continue;
                }
                BlockLoader.RowStrideReader rowStride = field.rowStride.reader(shard, segment, firstDoc);
                rowStrideReaders.add(new RowStrideReaderWork(rowStride, (Block.Builder)field.info.blockLoaders.get(shard).builder((BlockLoader.BlockFactory)loaderBlockFactory, docs.getPositionCount()), b));
                storedFieldsSpec = storedFieldsSpec.merge(field.info.blockLoaders.get(shard).rowStrideStoredFieldSpec());
            }
            if (rowStrideReaders.isEmpty()) {
                return;
            }
            if (storedFieldsSpec.equals((Object)StoredFieldsSpec.NO_REQUIREMENTS)) {
                throw new IllegalStateException("found row stride readers [" + rowStrideReaders + "] without stored fields [" + storedFieldsSpec + "]");
            }
            LeafReaderContext ctx = this.ctx(shard, segment);
            if (this.useSequentialStoredFieldsReader(docVector.docs())) {
                storedFieldLoader = StoredFieldLoader.fromSpecSequential((StoredFieldsSpec)storedFieldsSpec);
                this.trackStoredFields(storedFieldsSpec, true);
            } else {
                storedFieldLoader = StoredFieldLoader.fromSpec((StoredFieldsSpec)storedFieldsSpec);
                this.trackStoredFields(storedFieldsSpec, false);
            }
            BlockLoaderStoredFieldsFromLeafLoader storedFields = new BlockLoaderStoredFieldsFromLeafLoader(storedFieldLoader.getLoader(ctx, null), storedFieldsSpec.requiresSource() ? this.shardContexts.get((int)shard).newSourceLoader.get().leaf(ctx.reader(), null) : null);
            for (int p = 0; p < docs.getPositionCount(); ++p) {
                int doc = docs.getInt(p);
                if (storedFields != null) {
                    storedFields.advanceTo(doc);
                }
                for (int r = 0; r < rowStrideReaders.size(); ++r) {
                    RowStrideReaderWork work = (RowStrideReaderWork)rowStrideReaders.get(r);
                    work.reader.read(doc, (BlockLoader.StoredFields)storedFields, (BlockLoader.Builder)work.builder);
                }
            }
            for (int r = 0; r < rowStrideReaders.size(); ++r) {
                RowStrideReaderWork work = (RowStrideReaderWork)rowStrideReaders.get(r);
                blocks[work.offset] = work.builder.build();
            }
        }
        finally {
            Releasables.close(rowStrideReaders);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromManyLeaves(Block[] blocks, DocVector docVector) throws IOException {
        IntVector shards = docVector.shards();
        IntVector segments = docVector.segments();
        IntVector docs = docVector.docs();
        Releasable[] builders = new Block.Builder[blocks.length];
        int[] forwards = docVector.shardSegmentDocMapForwards();
        ComputeBlockLoaderFactory loaderBlockFactory = new ComputeBlockLoaderFactory(this.blockFactory, docs.getPositionCount());
        try {
            for (int b = 0; b < this.fields.size(); ++b) {
                FieldWork field = this.fields.get(b);
                builders[b] = this.builderFromFirstNonNull(loaderBlockFactory, field, docs.getPositionCount());
            }
            int lastShard = -1;
            int lastSegment = -1;
            BlockLoaderStoredFieldsFromLeafLoader storedFields = null;
            for (int i = 0; i < forwards.length; ++i) {
                int p = forwards[i];
                int shard = shards.getInt(p);
                int segment = segments.getInt(p);
                int doc = docs.getInt(p);
                if (shard != lastShard || segment != lastSegment) {
                    lastShard = shard;
                    lastSegment = segment;
                    StoredFieldsSpec storedFieldsSpec = this.storedFieldsSpecForShard(shard);
                    LeafReaderContext ctx = this.ctx(shard, segment);
                    storedFields = new BlockLoaderStoredFieldsFromLeafLoader(StoredFieldLoader.fromSpec((StoredFieldsSpec)storedFieldsSpec).getLoader(ctx, null), storedFieldsSpec.requiresSource() ? this.shardContexts.get((int)shard).newSourceLoader.get().leaf(ctx.reader(), null) : null);
                    if (!storedFieldsSpec.equals((Object)StoredFieldsSpec.NO_REQUIREMENTS)) {
                        this.trackStoredFields(storedFieldsSpec, false);
                    }
                }
                storedFields.advanceTo(doc);
                for (int r = 0; r < blocks.length; ++r) {
                    this.fields.get((int)r).rowStride.reader(shard, segment, doc).read(doc, (BlockLoader.StoredFields)storedFields, (BlockLoader.Builder)builders[r]);
                }
            }
            for (int r = 0; r < blocks.length; ++r) {
                try (Block orig = builders[r].build();){
                    blocks[r] = orig.filter(docVector.shardSegmentDocMapBackwards());
                    continue;
                }
            }
        }
        finally {
            Releasables.closeExpectNoException((Releasable[])builders);
        }
    }

    private boolean useSequentialStoredFieldsReader(IntVector docIds) {
        return docIds.getPositionCount() >= 10 && docIds.getInt(docIds.getPositionCount() - 1) - docIds.getInt(0) == docIds.getPositionCount() - 1;
    }

    private void trackStoredFields(StoredFieldsSpec spec, boolean sequential) {
        this.readersBuilt.merge("stored_fields[requires_source:" + spec.requiresSource() + ", fields:" + spec.requiredStoredFields().size() + ", sequential: " + sequential + "]", 1, (prev, one) -> prev + one);
    }

    private Block.Builder builderFromFirstNonNull(BlockLoader.BlockFactory loaderBlockFactory, FieldWork field, int positionCount) {
        for (BlockLoader loader : field.info.blockLoaders) {
            if (loader == BlockLoader.CONSTANT_NULLS) continue;
            return (Block.Builder)loader.builder(loaderBlockFactory, positionCount);
        }
        return (Block.Builder)field.info.blockLoaders.get(0).builder(loaderBlockFactory, positionCount);
    }

    private StoredFieldsSpec storedFieldsSpecForShard(int shard) {
        StoredFieldsSpec storedFieldsSpec = StoredFieldsSpec.NO_REQUIREMENTS;
        for (int b = 0; b < this.fields.size(); ++b) {
            FieldWork field = this.fields.get(b);
            storedFieldsSpec = storedFieldsSpec.merge(field.info.blockLoaders.get(shard).rowStrideStoredFieldSpec());
        }
        return storedFieldsSpec;
    }

    private LeafReaderContext ctx(int shard, int segment) {
        return (LeafReaderContext)this.shardContexts.get((int)shard).reader.leaves().get(segment);
    }

    @Override
    public String toString() {
        return "ValuesSourceReaderOperator[field = " + this.fields.stream().map(f -> f.info.name).collect(Collectors.joining(", ")) + "]";
    }

    @Override
    protected Status status(int pagesProcessed) {
        return new Status(new TreeMap<String, Integer>(this.readersBuilt), pagesProcessed);
    }

    private static class ComputeBlockLoaderFactory
    implements BlockLoader.BlockFactory {
        private final BlockFactory factory;
        private final int pageSize;
        private Block nullBlock;

        private ComputeBlockLoaderFactory(BlockFactory factory, int pageSize) {
            this.factory = factory;
            this.pageSize = pageSize;
        }

        public BlockLoader.BooleanBuilder booleansFromDocValues(int expectedCount) {
            return this.factory.newBooleanBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        public BlockLoader.BooleanBuilder booleans(int expectedCount) {
            return this.factory.newBooleanBlockBuilder(expectedCount);
        }

        public BlockLoader.BytesRefBuilder bytesRefsFromDocValues(int expectedCount) {
            return this.factory.newBytesRefBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        public BlockLoader.BytesRefBuilder bytesRefs(int expectedCount) {
            return this.factory.newBytesRefBlockBuilder(expectedCount);
        }

        public BlockLoader.DoubleBuilder doublesFromDocValues(int expectedCount) {
            return this.factory.newDoubleBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        public BlockLoader.DoubleBuilder doubles(int expectedCount) {
            return this.factory.newDoubleBlockBuilder(expectedCount);
        }

        public BlockLoader.IntBuilder intsFromDocValues(int expectedCount) {
            return this.factory.newIntBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        public BlockLoader.IntBuilder ints(int expectedCount) {
            return this.factory.newIntBlockBuilder(expectedCount);
        }

        public BlockLoader.LongBuilder longsFromDocValues(int expectedCount) {
            return this.factory.newLongBlockBuilder(expectedCount).mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        }

        public BlockLoader.LongBuilder longs(int expectedCount) {
            return this.factory.newLongBlockBuilder(expectedCount);
        }

        public BlockLoader.Builder nulls(int expectedCount) {
            return ElementType.NULL.newBlockBuilder(expectedCount, this.factory);
        }

        public Block constantNulls() {
            if (this.nullBlock == null) {
                this.nullBlock = this.factory.newConstantNullBlock(this.pageSize);
            } else {
                this.nullBlock.incRef();
            }
            return this.nullBlock;
        }

        public BytesRefBlock constantBytes(BytesRef value) {
            return this.factory.newConstantBytesRefBlockWith(value, this.pageSize);
        }

        public BlockLoader.SingletonOrdinalsBuilder singletonOrdinalsBuilder(SortedDocValues ordinals, int count) {
            return new SingletonOrdinalsBuilder(this.factory, ordinals, count);
        }
    }

    private class FieldWork {
        final FieldInfo info;
        final GuardedReader<BlockLoader.ColumnAtATimeReader> columnAtATime = new GuardedReader<BlockLoader.ColumnAtATimeReader>(){

            @Override
            BlockLoader.ColumnAtATimeReader build(BlockLoader loader, LeafReaderContext ctx) throws IOException {
                return loader.columnAtATimeReader(ctx);
            }

            @Override
            String type() {
                return "column_at_a_time";
            }
        };
        final GuardedReader<BlockLoader.RowStrideReader> rowStride = new GuardedReader<BlockLoader.RowStrideReader>(){

            @Override
            BlockLoader.RowStrideReader build(BlockLoader loader, LeafReaderContext ctx) throws IOException {
                return loader.rowStrideReader(ctx);
            }

            @Override
            String type() {
                return "row_stride";
            }
        };

        FieldWork(FieldInfo info) {
            this.info = info;
        }

        private abstract class GuardedReader<V extends BlockLoader.Reader> {
            private int lastShard = -1;
            private int lastSegment = -1;
            V lastReader;

            private GuardedReader() {
            }

            V reader(int shard, int segment, int startingDocId) throws IOException {
                if (this.lastShard == shard && this.lastSegment == segment) {
                    if (this.lastReader == null) {
                        return null;
                    }
                    if (this.lastReader.canReuse(startingDocId)) {
                        return this.lastReader;
                    }
                }
                this.lastShard = shard;
                this.lastSegment = segment;
                this.lastReader = this.build(FieldWork.this.info.blockLoaders.get(shard), ValuesSourceReaderOperator.this.ctx(shard, segment));
                ValuesSourceReaderOperator.this.readersBuilt.merge(FieldWork.this.info.name + ":" + this.type() + ":" + this.lastReader, 1, (prev, one) -> prev + one);
                return this.lastReader;
            }

            abstract V build(BlockLoader var1, LeafReaderContext var2) throws IOException;

            abstract String type();
        }
    }

    private record RowStrideReaderWork(BlockLoader.RowStrideReader reader, Block.Builder builder, int offset) implements Releasable
    {
        public void close() {
            this.builder.close();
        }
    }

    public record FieldInfo(String name, List<BlockLoader> blockLoaders) {
    }

    public record ShardContext(IndexReader reader, Supplier<SourceLoader> newSourceLoader) {
    }

    public static class Status
    extends AbstractPageMappingOperator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "values_source_reader", Status::new);
        private final Map<String, Integer> readersBuilt;

        Status(Map<String, Integer> readersBuilt, int pagesProcessed) {
            super(pagesProcessed);
            this.readersBuilt = readersBuilt;
        }

        Status(StreamInput in) throws IOException {
            super(in);
            this.readersBuilt = in.readOrderedMap(StreamInput::readString, StreamInput::readVInt);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.readersBuilt, StreamOutput::writeVInt);
        }

        @Override
        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public Map<String, Integer> readersBuilt() {
            return this.readersBuilt;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject("readers_built");
            for (Map.Entry<String, Integer> e : this.readersBuilt.entrySet()) {
                builder.field(e.getKey(), e.getValue());
            }
            builder.endObject();
            builder.field("pages_processed", this.pagesProcessed());
            return builder.endObject();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.pagesProcessed() == status.pagesProcessed() && this.readersBuilt.equals(status.readersBuilt);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.readersBuilt, this.pagesProcessed());
        }

        @Override
        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public record Factory(List<FieldInfo> fields, List<ShardContext> shardContexts, int docChannel) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new ValuesSourceReaderOperator(driverContext.blockFactory(), this.fields, this.shardContexts, this.docChannel);
        }

        @Override
        public String describe() {
            return "ValuesSourceReaderOperator[field = " + this.fields.stream().map(f -> f.name).collect(Collectors.joining(", ")) + "]";
        }
    }
}

