/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public class IdFieldIndexFieldData
implements IndexFieldData<IdFieldLeafFieldData> {
    private static final String FIELD_NAME = "_id";
    private final ValuesSourceType valuesSourceType;
    private final StoredFieldLoader loader;

    protected IdFieldIndexFieldData(ValuesSourceType valuesSourceType) {
        this.valuesSourceType = valuesSourceType;
        this.loader = StoredFieldLoader.create((boolean)false, Set.of(FIELD_NAME));
    }

    public String getFieldName() {
        return FIELD_NAME;
    }

    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    public final IdFieldLeafFieldData load(LeafReaderContext context) {
        try {
            return this.loadDirect(context);
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    public final IdFieldLeafFieldData loadDirect(LeafReaderContext context) throws Exception {
        return new IdFieldLeafFieldData(this.loader.getLoader(context, null));
    }

    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("not supported for stored field fallback");
    }

    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("not supported for stored field fallback");
    }

    class IdFieldLeafFieldData
    implements LeafFieldData {
        private final LeafStoredFieldLoader loader;

        protected IdFieldLeafFieldData(LeafStoredFieldLoader loader) {
            this.loader = loader;
        }

        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            throw new IllegalArgumentException("not supported for _id field");
        }

        public long ramBytesUsed() {
            return 0L;
        }

        public void close() {
        }

        public SortedBinaryDocValues getBytesValues() {
            return new SortedBinaryDocValues(){
                private String id;

                public boolean advanceExact(int doc) throws IOException {
                    IdFieldLeafFieldData.this.loader.advanceTo(doc);
                    this.id = IdFieldLeafFieldData.this.loader.id();
                    return this.id != null;
                }

                public int docValueCount() {
                    return 1;
                }

                public BytesRef nextValue() throws IOException {
                    return new BytesRef((CharSequence)this.id);
                }
            };
        }
    }
}

