/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Vector;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LongVector
extends Vector {
    public long getLong(int var1);

    @Override
    public LongBlock asBlock();

    @Override
    public LongVector filter(int ... var1);

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(LongVector vector1, LongVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getLong(pos) == vector2.getLong(pos)) continue;
            return false;
        }
        return true;
    }

    public static int hash(LongVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            long element = vector.getLong(pos);
            result = 31 * result + (int)(element ^ element >>> 32);
        }
        return result;
    }

    public static LongVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        boolean constant = in.readBoolean();
        if (constant && positions > 0) {
            return blockFactory.newConstantLongVector(in.readLong(), positions);
        }
        try (FixedBuilder builder = blockFactory.newLongVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendLong(in.readLong());
            }
            LongVector longVector = builder.build();
            return longVector;
        }
    }

    default public void writeTo(StreamOutput out) throws IOException {
        int positions = this.getPositionCount();
        out.writeVInt(positions);
        out.writeBoolean(this.isConstant());
        if (this.isConstant() && positions > 0) {
            out.writeLong(this.getLong(0));
        } else {
            for (int i = 0; i < positions; ++i) {
                out.writeLong(this.getLong(i));
            }
        }
    }

    @Deprecated
    public static Builder newVectorBuilder(int estimatedSize) {
        return LongVector.newVectorBuilder(estimatedSize, BlockFactory.getNonBreakingInstance());
    }

    @Deprecated
    public static Builder newVectorBuilder(int estimatedSize, BlockFactory blockFactory) {
        return blockFactory.newLongVectorBuilder(estimatedSize);
    }

    @Deprecated
    public static FixedBuilder newVectorFixedBuilder(int size, BlockFactory blockFactory) {
        return blockFactory.newLongVectorFixedBuilder(size);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FixedBuilder
    extends Vector.Builder {
        public FixedBuilder appendLong(long var1);

        @Override
        public LongVector build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Vector.Builder {
        public Builder appendLong(long var1);

        @Override
        public LongVector build();
    }
}

