/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.index.mapper.BlockLoader;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DoubleBlock
extends Block {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Block.class, "DoubleBlock", DoubleBlock::readFrom);

    public double getDouble(int var1);

    @Override
    public DoubleVector asVector();

    @Override
    public DoubleBlock filter(int ... var1);

    default public String getWriteableName() {
        return "DoubleBlock";
    }

    private static DoubleBlock readFrom(StreamInput in) throws IOException {
        return DoubleBlock.readFrom((BlockStreamInput)in);
    }

    private static DoubleBlock readFrom(BlockStreamInput in) throws IOException {
        boolean isVector = in.readBoolean();
        if (isVector) {
            return DoubleVector.readFrom(in.blockFactory(), (StreamInput)in).asBlock();
        }
        int positions = in.readVInt();
        try (Builder builder = in.blockFactory().newDoubleBlockBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                if (in.readBoolean()) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = in.readVInt();
                builder.beginPositionEntry();
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    builder.appendDouble(in.readDouble());
                }
                builder.endPositionEntry();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    default public void writeTo(StreamOutput out) throws IOException {
        DoubleVector vector = this.asVector();
        out.writeBoolean(vector != null);
        if (vector != null) {
            vector.writeTo(out);
        } else {
            int positions = this.getPositionCount();
            out.writeVInt(positions);
            for (int pos = 0; pos < positions; ++pos) {
                if (this.isNull(pos)) {
                    out.writeBoolean(true);
                    continue;
                }
                out.writeBoolean(false);
                int valueCount = this.getValueCount(pos);
                out.writeVInt(valueCount);
                for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                    out.writeDouble(this.getDouble(this.getFirstValueIndex(pos) + valueIndex));
                }
            }
        }
    }

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(DoubleBlock block1, DoubleBlock block2) {
        if (block1 == block2) {
            return true;
        }
        int positions = block1.getPositionCount();
        if (positions != block2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (block1.isNull(pos) || block2.isNull(pos)) {
                if (block1.isNull(pos) == block2.isNull(pos)) continue;
                return false;
            }
            int valueCount = block1.getValueCount(pos);
            if (valueCount != block2.getValueCount(pos)) {
                return false;
            }
            int b1ValueIdx = block1.getFirstValueIndex(pos);
            int b2ValueIdx = block2.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                if (block1.getDouble(b1ValueIdx + valueIndex) == block2.getDouble(b2ValueIdx + valueIndex)) continue;
                return false;
            }
        }
        return true;
    }

    public static int hash(DoubleBlock block) {
        int positions = block.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < positions; ++pos) {
            if (block.isNull(pos)) {
                result = 31 * result - 1;
                continue;
            }
            int valueCount = block.getValueCount(pos);
            result = 31 * result + valueCount;
            int firstValueIdx = block.getFirstValueIndex(pos);
            for (int valueIndex = 0; valueIndex < valueCount; ++valueIndex) {
                long element = Double.doubleToLongBits(block.getDouble(firstValueIdx + valueIndex));
                result = 31 * result + (int)(element ^ element >>> 32);
            }
        }
        return result;
    }

    @Deprecated
    public static Builder newBlockBuilder(int estimatedSize) {
        return DoubleBlock.newBlockBuilder(estimatedSize, BlockFactory.getNonBreakingInstance());
    }

    @Deprecated
    public static Builder newBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        return blockFactory.newDoubleBlockBuilder(estimatedSize);
    }

    @Deprecated
    public static DoubleBlock newConstantBlockWith(double value, int positions) {
        return DoubleBlock.newConstantBlockWith(value, positions, BlockFactory.getNonBreakingInstance());
    }

    @Deprecated
    public static DoubleBlock newConstantBlockWith(double value, int positions, BlockFactory blockFactory) {
        return blockFactory.newConstantDoubleBlockWith(value, positions);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Builder
    extends Block.Builder,
    BlockLoader.DoubleBuilder {
        public Builder appendDouble(double var1);

        public Builder copyFrom(DoubleBlock var1, int var2, int var3);

        @Override
        public Builder appendNull();

        @Override
        public Builder beginPositionEntry();

        @Override
        public Builder endPositionEntry();

        @Override
        public Builder copyFrom(Block var1, int var2, int var3);

        @Override
        public Builder mvOrdering(Block.MvOrdering var1);

        @Override
        public Builder appendAllValuesToCurrentPosition(Block var1);

        public Builder appendAllValuesToCurrentPosition(DoubleBlock var1);

        @Override
        public DoubleBlock build();
    }
}

