/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.DoubleVectorBlock;
import org.elasticsearch.compute.data.ElementType;

public final class DoubleArrayVector
extends AbstractVector
implements DoubleVector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DoubleArrayVector.class);
    private final double[] values;
    private final DoubleBlock block;

    public DoubleArrayVector(double[] values, int positionCount) {
        this(values, positionCount, BlockFactory.getNonBreakingInstance());
    }

    public DoubleArrayVector(double[] values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
        this.block = new DoubleVectorBlock(this);
    }

    @Override
    public DoubleBlock asBlock() {
        return this.block;
    }

    @Override
    public double getDouble(int position) {
        return this.values[position];
    }

    @Override
    public ElementType elementType() {
        return ElementType.DOUBLE;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public DoubleVector filter(int ... positions) {
        try (DoubleVector.Builder builder = this.blockFactory().newDoubleVectorBuilder(positions.length);){
            for (int pos : positions) {
                builder.appendDouble(this.values[pos]);
            }
            DoubleVector doubleVector = builder.build();
            return doubleVector;
        }
    }

    public static long ramBytesEstimated(double[] values) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((double[])values);
    }

    public long ramBytesUsed() {
        return DoubleArrayVector.ramBytesEstimated(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DoubleVector) {
            DoubleVector that = (DoubleVector)obj;
            return DoubleVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return DoubleVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + Arrays.toString(this.values) + "]";
    }
}

