/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.BytesRefVectorBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class BytesRefArrayVector
extends AbstractVector
implements BytesRefVector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BytesRefArrayVector.class);
    private final BytesRefArray values;
    private final BytesRefBlock block;

    public BytesRefArrayVector(BytesRefArray values, int positionCount) {
        this(values, positionCount, BlockFactory.getNonBreakingInstance());
    }

    public BytesRefArrayVector(BytesRefArray values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
        this.block = new BytesRefVectorBlock(this);
    }

    @Override
    public BytesRefBlock asBlock() {
        return this.block;
    }

    @Override
    public BytesRef getBytesRef(int position, BytesRef dest) {
        return this.values.get((long)position, dest);
    }

    @Override
    public ElementType elementType() {
        return ElementType.BYTES_REF;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public BytesRefVector filter(int ... positions) {
        BytesRef scratch = new BytesRef();
        try (BytesRefVector.Builder builder = this.blockFactory().newBytesRefVectorBuilder(positions.length);){
            for (int pos : positions) {
                builder.appendBytesRef(this.values.get((long)pos, scratch));
            }
            BytesRefVector bytesRefVector = builder.build();
            return bytesRefVector;
        }
    }

    public static long ramBytesEstimated(BytesRefArray values) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((Accountable)values);
    }

    public long ramBytesUsed() {
        return BytesRefArrayVector.ramBytesEstimated(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BytesRefVector) {
            BytesRefVector that = (BytesRefVector)obj;
            return BytesRefVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BytesRefVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + "]";
    }

    @Override
    public void close() {
        if (this.released) {
            throw new IllegalStateException("can't release already released vector [" + this + "]");
        }
        this.released = true;
        this.blockFactory().adjustBreaker(-this.ramBytesUsed() + this.values.bigArraysRamBytesUsed(), true);
        Releasables.closeExpectNoException((Releasable)this.values);
    }
}

