/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountGroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.LongState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public class CountAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("count", ElementType.LONG), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final LongState state;
    private final List<Integer> channels;
    private final boolean countAll;

    public static AggregatorFunctionSupplier supplier(BigArrays bigArrays, final List<Integer> channels) {
        return new AggregatorFunctionSupplier(){

            @Override
            public AggregatorFunction aggregator(DriverContext driverContext) {
                return CountAggregatorFunction.create(channels);
            }

            @Override
            public GroupingAggregatorFunction groupingAggregator(DriverContext driverContext) {
                return CountGroupingAggregatorFunction.create(driverContext, channels);
            }

            @Override
            public String describe() {
                return "count";
            }
        };
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    public static CountAggregatorFunction create(List<Integer> inputChannels) {
        return new CountAggregatorFunction(inputChannels, new LongState());
    }

    private CountAggregatorFunction(List<Integer> channels, LongState state) {
        this.channels = channels;
        this.state = state;
        this.countAll = channels.isEmpty();
    }

    @Override
    public int intermediateBlockCount() {
        return CountAggregatorFunction.intermediateStateDesc().size();
    }

    private int blockIndex() {
        return this.countAll ? 0 : this.channels.get(0);
    }

    @Override
    public void addRawInput(Page page) {
        Object block = page.getBlock(this.blockIndex());
        LongState state = this.state;
        int count = this.countAll ? block.getPositionCount() : block.getTotalValueCount();
        state.longValue(state.longValue() + (long)count);
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        int blockIndex = this.blockIndex();
        assert (page.getBlockCount() >= blockIndex + CountAggregatorFunction.intermediateStateDesc().size());
        Object uncastBlock = page.getBlock(this.channels.get(0));
        if (uncastBlock.areAllValuesNull()) {
            return;
        }
        LongVector count = ((LongBlock)page.getBlock(this.channels.get(0))).asVector();
        BooleanVector seen = ((BooleanBlock)page.getBlock(this.channels.get(1))).asVector();
        assert (count.getPositionCount() == 1);
        assert (count.getPositionCount() == seen.getPositionCount());
        this.state.longValue(this.state.longValue() + count.getLong(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = driverContext.blockFactory().newConstantLongBlockWith(this.state.longValue(), 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

