/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchbusinessrules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.searchbusinessrules.CappedScoreQuery;

public class PinnedQueryBuilder
extends AbstractQueryBuilder<PinnedQueryBuilder> {
    public static final String NAME = "pinned";
    public static final int MAX_NUM_PINNED_HITS = 100;
    public static final ParseField IDS_FIELD = new ParseField("ids", new String[0]);
    public static final ParseField DOCS_FIELD = new ParseField("docs", new String[0]);
    public static final ParseField ORGANIC_QUERY_FIELD = new ParseField("organic", new String[0]);
    private static final TransportVersion OPTIONAL_INDEX_IN_DOCS_VERSION = TransportVersions.PINNED_QUERY_OPTIONAL_INDEX;
    private final List<String> ids;
    private final List<Item> docs;
    private QueryBuilder organicQuery;
    private static final float MAX_ORGANIC_SCORE = Float.intBitsToFloat(0x7F000000) - 1.0f;
    private static final ConstructingObjectParser<PinnedQueryBuilder, Void> PARSER = new ConstructingObjectParser("pinned", a -> {
        QueryBuilder organicQuery = (QueryBuilder)a[0];
        List ids = (List)a[1];
        List docs = (List)a[2];
        return new PinnedQueryBuilder(organicQuery, ids, docs);
    });

    public PinnedQueryBuilder(QueryBuilder organicQuery, String ... ids) {
        this(organicQuery, Arrays.asList(ids), null);
    }

    public PinnedQueryBuilder(QueryBuilder organicQuery, Item ... docs) {
        this(organicQuery, null, Arrays.asList(docs));
    }

    private PinnedQueryBuilder(QueryBuilder organicQuery, List<String> ids, List<Item> docs) {
        LinkedHashSet<Object> deduped;
        if (organicQuery == null) {
            throw new IllegalArgumentException("[pinned] organicQuery cannot be null");
        }
        this.organicQuery = organicQuery;
        if (ids == null && docs == null) {
            throw new IllegalArgumentException("[pinned] ids and docs cannot both be null");
        }
        if (ids != null && docs != null) {
            throw new IllegalArgumentException("[pinned] ids and docs cannot both be used");
        }
        if (ids != null) {
            if (ids.size() > 100) {
                throw new IllegalArgumentException("[pinned] Max of 100 ids exceeded: " + ids.size() + " provided.");
            }
            deduped = new LinkedHashSet<Object>();
            for (String id : ids) {
                if (id == null) {
                    throw new IllegalArgumentException("[pinned] id cannot be null");
                }
                if (deduped.add(id)) continue;
                throw new IllegalArgumentException("[pinned] duplicate id found in list: " + id);
            }
        }
        if (docs != null) {
            if (docs.size() > 100) {
                throw new IllegalArgumentException("[pinned] Max of 100 docs exceeded: " + docs.size() + " provided.");
            }
            deduped = new LinkedHashSet();
            for (Item doc : docs) {
                if (doc == null) {
                    throw new IllegalArgumentException("[pinned] doc cannot be null");
                }
                if (deduped.add(doc)) continue;
                throw new IllegalArgumentException("[pinned] duplicate doc found in list: " + doc);
            }
        }
        this.ids = ids;
        this.docs = docs;
    }

    public PinnedQueryBuilder(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().before((VersionId)TransportVersions.V_7_15_0)) {
            this.ids = in.readStringCollectionAsList();
            this.docs = null;
        } else {
            this.ids = in.readOptionalStringCollectionAsList();
            this.docs = in.readBoolean() ? in.readCollectionAsList(Item::new) : null;
        }
        this.organicQuery = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before((VersionId)TransportVersions.V_7_15_0)) {
            out.writeStringCollection(this.ids);
        } else {
            out.writeOptionalStringCollection(this.ids);
            if (this.docs == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeCollection(this.docs);
            }
        }
        out.writeNamedWriteable((NamedWriteable)this.organicQuery);
    }

    public QueryBuilder organicQuery() {
        return this.organicQuery;
    }

    public List<String> ids() {
        if (this.ids == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.ids);
    }

    public List<Item> docs() {
        if (this.docs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.docs);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.organicQuery != null) {
            builder.field(ORGANIC_QUERY_FIELD.getPreferredName());
            this.organicQuery.toXContent(builder, params);
        }
        if (this.ids != null) {
            builder.startArray(IDS_FIELD.getPreferredName());
            for (String value : this.ids) {
                builder.value(value);
            }
            builder.endArray();
        }
        if (this.docs != null) {
            builder.startArray(DOCS_FIELD.getPreferredName());
            for (Item item : this.docs) {
                builder.value((ToXContent)item);
            }
            builder.endArray();
        }
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    public static PinnedQueryBuilder fromXContent(XContentParser parser) {
        try {
            return (PinnedQueryBuilder)((Object)PARSER.apply(parser, null));
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder newOrganicQuery = this.organicQuery.rewrite(queryRewriteContext);
        if (newOrganicQuery != this.organicQuery) {
            PinnedQueryBuilder result = new PinnedQueryBuilder(newOrganicQuery, this.ids, this.docs);
            result.boost(this.boost);
            return result;
        }
        return this;
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        List<Item> items;
        MappedFieldType idField = context.getFieldType("_id");
        if (idField == null) {
            return new MatchNoDocsQuery("No mappings");
        }
        List<Item> list = items = this.docs != null ? this.docs : this.ids.stream().map(id -> new Item((String)id)).toList();
        if (items.isEmpty()) {
            return new CappedScoreQuery(this.organicQuery.toQuery(context), MAX_ORGANIC_SCORE);
        }
        ArrayList<BoostQuery> pinnedQueries = new ArrayList<BoostQuery>();
        int minPin = NumericUtils.floatToSortableInt((float)MAX_ORGANIC_SCORE) + 1;
        int boostNum = minPin + items.size();
        float lastScore = Float.MAX_VALUE;
        for (Item item : items) {
            float pinScore = NumericUtils.sortableIntToFloat((int)boostNum);
            assert (pinScore < lastScore);
            lastScore = pinScore;
            --boostNum;
            if (item.index != null && !context.indexMatches(item.index)) continue;
            BoostQuery idQuery = new BoostQuery((Query)new ConstantScoreQuery(idField.termQuery((Object)item.id, context)), pinScore);
            pinnedQueries.add(idQuery);
        }
        ArrayList<Object> organicAndPinned = new ArrayList<Object>();
        organicAndPinned.add(new DisjunctionMaxQuery(pinnedQueries, 0.0f));
        organicAndPinned.add((Object)new CappedScoreQuery(this.organicQuery.toQuery(context), MAX_ORGANIC_SCORE));
        return new DisjunctionMaxQuery(organicAndPinned, 0.0f);
    }

    protected int doHashCode() {
        return Objects.hash(this.ids, this.docs, this.organicQuery);
    }

    protected boolean doEquals(PinnedQueryBuilder other) {
        return Objects.equals(this.ids, other.ids) && Objects.equals(this.docs, other.docs) && Objects.equals(this.organicQuery, other.organicQuery) && this.boost == other.boost;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_4_0;
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> PinnedQueryBuilder.parseInnerQueryBuilder((XContentParser)p), ORGANIC_QUERY_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), IDS_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), Item.PARSER, DOCS_FIELD);
        PinnedQueryBuilder.declareStandardFields(PARSER);
    }

    public static final class Item
    implements ToXContentObject,
    Writeable {
        public static final String NAME = "item";
        public static final ParseField INDEX_FIELD = new ParseField("_index", new String[0]);
        public static final ParseField ID_FIELD = new ParseField("_id", new String[0]);
        private final String index;
        private final String id;
        private static final ConstructingObjectParser<Item, Void> PARSER = new ConstructingObjectParser("item", a -> new Item((String)a[0], (String)a[1]));

        public Item(String index, String id) {
            if (index != null && Regex.isSimpleMatchPattern((String)index)) {
                throw new IllegalArgumentException("Item index cannot contain wildcard expressions");
            }
            if (id == null) {
                throw new IllegalArgumentException("Item requires id to be non-null");
            }
            this.index = index;
            this.id = id;
        }

        private Item(String id) {
            this.index = null;
            this.id = id;
        }

        public Item(StreamInput in) throws IOException {
            this.index = in.getTransportVersion().onOrAfter((VersionId)OPTIONAL_INDEX_IN_DOCS_VERSION) ? in.readOptionalString() : in.readString();
            this.id = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter((VersionId)OPTIONAL_INDEX_IN_DOCS_VERSION)) {
                out.writeOptionalString(this.index);
            } else {
                if (this.index == null) {
                    throw new IllegalArgumentException("[_index] needs to be specified for docs elements when cluster nodes are not in the same version");
                }
                out.writeString(this.index);
            }
            out.writeString(this.id);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.index != null) {
                builder.field(INDEX_FIELD.getPreferredName(), this.index);
            }
            builder.field(ID_FIELD.getPreferredName(), this.id);
            return builder.endObject();
        }

        public String toString() {
            return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.id);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            return Objects.equals(this.index, other.index) && Objects.equals(this.id, other.id);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEX_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), ID_FIELD);
        }
    }
}

