/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import org.elasticsearch.search.aggregations.ParsedAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalCentroid;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.CartesianCentroid;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.InternalCartesianCentroid;

public class ParsedCartesianCentroid
extends ParsedAggregation
implements CartesianCentroid {
    private CartesianPoint centroid;
    private long count;
    private static final ObjectParser<ParsedCartesianCentroid, Void> PARSER = new ObjectParser(ParsedCartesianCentroid.class.getSimpleName(), true, ParsedCartesianCentroid::new);
    private static final ObjectParser<CartesianPoint, Void> CARTESIAN_POINT_PARSER = new ObjectParser(ParsedCartesianCentroid.class.getSimpleName() + "_POINT", true, CartesianPoint::new);

    public CartesianPoint centroid() {
        return this.centroid;
    }

    public long count() {
        return this.count;
    }

    public String getType() {
        return "cartesian_centroid";
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.centroid != null) {
            builder.startObject(InternalCentroid.Fields.CENTROID.getPreferredName());
            builder.field(InternalCartesianCentroid.Fields.CENTROID_X.getPreferredName(), this.centroid.getX());
            builder.field(InternalCartesianCentroid.Fields.CENTROID_Y.getPreferredName(), this.centroid.getY());
            builder.endObject();
        }
        builder.field(InternalCentroid.Fields.COUNT.getPreferredName(), this.count);
        return builder;
    }

    public static ParsedCartesianCentroid fromXContent(XContentParser parser, String name) {
        ParsedCartesianCentroid centroid = (ParsedCartesianCentroid)PARSER.apply(parser, null);
        centroid.setName(name);
        return centroid;
    }

    static {
        ParsedCartesianCentroid.declareAggregationFields(PARSER);
        PARSER.declareObject((agg, centroid) -> {
            agg.centroid = centroid;
        }, CARTESIAN_POINT_PARSER, InternalCentroid.Fields.CENTROID);
        PARSER.declareLong((agg, count) -> {
            agg.count = count;
        }, InternalCentroid.Fields.COUNT);
        CARTESIAN_POINT_PARSER.declareDouble(CartesianPoint::resetX, InternalCartesianCentroid.Fields.CENTROID_X);
        CARTESIAN_POINT_PARSER.declareDouble(CartesianPoint::resetY, InternalCartesianCentroid.Fields.CENTROID_Y);
    }
}

