/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.script.GeometryFieldScript;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.index.fielddata.CentroidCalculator;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.index.fielddata.GeometryDocValueWriter;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSourceType;

public final class GeoShapeScriptDocValues
extends GeoShapeValues {
    private final GeometryFieldScript script;
    private final GeoShapeValues.GeoShapeValue geoShapeValue = new GeoShapeValues.GeoShapeValue();
    private final GeoShapeIndexer indexer;

    public GeoShapeScriptDocValues(GeometryFieldScript script, String fieldName) {
        this.script = script;
        this.indexer = new GeoShapeIndexer(Orientation.CCW, fieldName);
    }

    @Override
    public boolean advanceExact(int docId) {
        this.script.runForDoc(docId);
        return this.script.count() != 0;
    }

    @Override
    public ValuesSourceType valuesSourceType() {
        return GeoShapeValuesSourceType.instance();
    }

    @Override
    public GeoShapeValues.GeoShapeValue value() throws IOException {
        Geometry geometry = this.script.geometry();
        if (geometry == null) {
            return null;
        }
        List fields = this.indexer.getIndexableFields(geometry);
        CentroidCalculator centroidCalculator = new CentroidCalculator();
        centroidCalculator.add(geometry);
        this.geoShapeValue.reset(GeometryDocValueWriter.write(fields, CoordinateEncoder.GEO, centroidCalculator));
        return this.geoShapeValue;
    }
}

