/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.action;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.spatial.action.SpatialStatsAction;
import org.elasticsearch.xpack.spatial.SpatialUsage;

public class SpatialStatsTransportAction
extends TransportNodesAction<SpatialStatsAction.Request, SpatialStatsAction.Response, SpatialStatsAction.NodeRequest, SpatialStatsAction.NodeResponse> {
    private final SpatialUsage usage;

    @Inject
    public SpatialStatsTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, SpatialUsage usage) {
        super("cluster:monitor/xpack/spatial/stats", clusterService, transportService, actionFilters, SpatialStatsAction.NodeRequest::new, (Executor)threadPool.executor("management"));
        this.usage = usage;
    }

    protected SpatialStatsAction.Response newResponse(SpatialStatsAction.Request request, List<SpatialStatsAction.NodeResponse> nodes, List<FailedNodeException> failures) {
        return new SpatialStatsAction.Response(this.clusterService.getClusterName(), nodes, failures);
    }

    protected SpatialStatsAction.NodeRequest newNodeRequest(SpatialStatsAction.Request request) {
        return new SpatialStatsAction.NodeRequest();
    }

    protected SpatialStatsAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new SpatialStatsAction.NodeResponse(in);
    }

    protected SpatialStatsAction.NodeResponse nodeOperation(SpatialStatsAction.NodeRequest request, Task task) {
        return this.usage.stats(this.clusterService.localNode());
    }
}

