/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene70;

import org.apache.lucene.backward_codecs.lucene50.Lucene50CompoundFormat;
import org.apache.lucene.backward_codecs.lucene50.Lucene50LiveDocsFormat;
import org.apache.lucene.backward_codecs.lucene50.Lucene50StoredFieldsFormat;
import org.apache.lucene.backward_codecs.lucene60.Lucene60FieldInfosFormat;
import org.apache.lucene.backward_codecs.lucene70.Lucene70SegmentInfoFormat;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.perfield.PerFieldDocValuesFormat;
import org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;
import org.elasticsearch.xpack.lucene.bwc.codecs.BWCCodec;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene60.Lucene60MetadataOnlyPointsFormat;

public class BWCLucene70Codec
extends BWCCodec {
    private final FieldInfosFormat fieldInfosFormat = BWCLucene70Codec.wrap((FieldInfosFormat)new Lucene60FieldInfosFormat());
    private final SegmentInfoFormat segmentInfosFormat = BWCLucene70Codec.wrap((SegmentInfoFormat)new Lucene70SegmentInfoFormat());
    private final LiveDocsFormat liveDocsFormat = new Lucene50LiveDocsFormat();
    private final CompoundFormat compoundFormat = new Lucene50CompoundFormat();
    private final StoredFieldsFormat storedFieldsFormat;
    private final DocValuesFormat defaultDVFormat = DocValuesFormat.forName((String)"Lucene70");
    private final DocValuesFormat docValuesFormat = new PerFieldDocValuesFormat(){

        public DocValuesFormat getDocValuesFormatForField(String field) {
            return BWCLucene70Codec.this.defaultDVFormat;
        }
    };
    private final PostingsFormat postingsFormat = new PerFieldPostingsFormat(){

        public PostingsFormat getPostingsFormatForField(String field) {
            throw new IllegalStateException("This codec should only be used for reading, not writing");
        }
    };

    public BWCLucene70Codec() {
        super("BWCLucene70Codec");
        this.storedFieldsFormat = new Lucene50StoredFieldsFormat(Lucene50StoredFieldsFormat.Mode.BEST_SPEED);
    }

    public FieldInfosFormat fieldInfosFormat() {
        return this.fieldInfosFormat;
    }

    public SegmentInfoFormat segmentInfoFormat() {
        return this.segmentInfosFormat;
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public LiveDocsFormat liveDocsFormat() {
        return this.liveDocsFormat;
    }

    public CompoundFormat compoundFormat() {
        return this.compoundFormat;
    }

    public final DocValuesFormat docValuesFormat() {
        return this.docValuesFormat;
    }

    public PostingsFormat postingsFormat() {
        return this.postingsFormat;
    }

    public PointsFormat pointsFormat() {
        return new Lucene60MetadataOnlyPointsFormat();
    }
}

