/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.metrics;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.telemetry.apm.AbstractInstrument;
import org.elasticsearch.telemetry.apm.internal.metrics.OtelHelper;
import org.elasticsearch.telemetry.metric.LongGauge;
import org.elasticsearch.telemetry.metric.LongWithAttributes;

public class LongGaugeAdapter
extends AbstractInstrument<ObservableLongGauge>
implements LongGauge {
    private final Supplier<LongWithAttributes> observer;
    private final ReleasableLock closedLock = new ReleasableLock((Lock)new ReentrantLock());
    private boolean closed = false;

    public LongGaugeAdapter(Meter meter, String name, String description, String unit, Supplier<LongWithAttributes> observer) {
        super(meter, name, description, unit);
        this.observer = observer;
    }

    @Override
    protected ObservableLongGauge buildInstrument(Meter meter) {
        return Objects.requireNonNull(meter).gaugeBuilder(this.getName()).ofLongs().setDescription(this.getDescription()).setUnit(this.getUnit()).buildWithCallback(measurement -> {
            LongWithAttributes observation;
            try {
                observation = this.observer.get();
            }
            catch (RuntimeException err) {
                assert (false) : "observer must not throw [" + err.getMessage() + "]";
                return;
            }
            measurement.record(observation.value(), OtelHelper.fromMap(observation.attributes()));
        });
    }

    public void close() throws Exception {
        try (ReleasableLock lock = this.closedLock.acquire();){
            if (!this.closed) {
                ((ObservableLongGauge)this.getInstrument()).close();
            }
            this.closed = true;
        }
    }
}

