/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm;

import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.TelemetryPlugin;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.telemetry.apm.internal.APMAgentSettings;
import org.elasticsearch.telemetry.apm.internal.APMMeterService;
import org.elasticsearch.telemetry.apm.internal.APMTelemetryProvider;
import org.elasticsearch.telemetry.apm.internal.tracing.APMTracer;

public class APM
extends Plugin
implements NetworkPlugin,
TelemetryPlugin {
    private static final Logger logger = LogManager.getLogger(APM.class);
    private final SetOnce<APMTelemetryProvider> telemetryProvider = new SetOnce();
    private final Settings settings;

    public APM(Settings settings) {
        this.settings = settings;
    }

    public TelemetryProvider getTelemetryProvider(Settings settings) {
        APMTelemetryProvider apmTelemetryProvider = new APMTelemetryProvider(settings);
        this.telemetryProvider.set((Object)apmTelemetryProvider);
        return apmTelemetryProvider;
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        APMTracer apmTracer = ((APMTelemetryProvider)this.telemetryProvider.get()).getTracer();
        apmTracer.setClusterName(services.clusterService().getClusterName().value());
        apmTracer.setNodeName(services.clusterService().getNodeName());
        APMAgentSettings apmAgentSettings = new APMAgentSettings();
        apmAgentSettings.syncAgentSystemProperties(this.settings);
        APMMeterService apmMeter = new APMMeterService(this.settings);
        apmAgentSettings.addClusterSettingsListeners(services.clusterService(), (APMTelemetryProvider)this.telemetryProvider.get(), apmMeter);
        logger.info("Sending apm metrics is {}", (Object)((Boolean)APMAgentSettings.TELEMETRY_METRICS_ENABLED_SETTING.get(this.settings) != false ? "enabled" : "disabled"));
        logger.info("Sending apm traces is {}", (Object)((Boolean)APMAgentSettings.APM_ENABLED_SETTING.get(this.settings) != false ? "enabled" : "disabled"));
        return List.of(apmTracer, apmMeter);
    }

    public List<Setting<?>> getSettings() {
        return List.of(APMAgentSettings.APM_ENABLED_SETTING, APMAgentSettings.TELEMETRY_METRICS_ENABLED_SETTING, APMAgentSettings.APM_TRACING_NAMES_INCLUDE_SETTING, APMAgentSettings.APM_TRACING_NAMES_EXCLUDE_SETTING, APMAgentSettings.APM_TRACING_SANITIZE_FIELD_NAMES, APMAgentSettings.APM_AGENT_SETTINGS, APMAgentSettings.APM_SECRET_TOKEN_SETTING, APMAgentSettings.APM_API_KEY_SETTING);
    }
}

