/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.existence;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.Processors;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;

public class FrozenExistenceDeciderService
implements AutoscalingDeciderService {
    public static final String NAME = "frozen_existence";
    static final ByteSizeValue MINIMUM_FROZEN_MEMORY = ByteSizeValue.ofGb((long)1L);
    static final ByteSizeValue MINIMUM_FROZEN_STORAGE = ByteSizeValue.ofGb((long)8L);
    static String FROZEN_PHASE = "frozen";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public AutoscalingDeciderResult scale(Settings configuration, AutoscalingDeciderContext context) {
        List<String> indicesNeedingFrozen = context.state().metadata().stream().filter(FrozenExistenceDeciderService::isFrozenPhase).map(imd -> imd.getIndex().getName()).limit(10L).collect(Collectors.toList());
        AutoscalingCapacity.Builder builder = AutoscalingCapacity.builder();
        if (indicesNeedingFrozen.size() > 0) {
            builder.total(MINIMUM_FROZEN_STORAGE, MINIMUM_FROZEN_MEMORY, null);
            builder.node(MINIMUM_FROZEN_STORAGE, MINIMUM_FROZEN_MEMORY, null);
        } else {
            builder.total(ByteSizeValue.ZERO, ByteSizeValue.ZERO, Processors.ZERO);
        }
        return new AutoscalingDeciderResult(builder.build(), new FrozenExistenceReason(indicesNeedingFrozen));
    }

    @Override
    public List<Setting<?>> deciderSettings() {
        return Collections.emptyList();
    }

    @Override
    public List<DiscoveryNodeRole> roles() {
        return List.of(DiscoveryNodeRole.DATA_FROZEN_NODE_ROLE);
    }

    static boolean isFrozenPhase(IndexMetadata indexMetadata) {
        return FROZEN_PHASE.equals(indexMetadata.getLifecycleExecutionState().phase());
    }

    public static class FrozenExistenceReason
    implements AutoscalingDeciderResult.Reason {
        private final List<String> indices;

        public FrozenExistenceReason(List<String> indices) {
            this.indices = indices;
        }

        public FrozenExistenceReason(StreamInput in) throws IOException {
            this.indices = in.readStringCollectionAsList();
        }

        @Override
        public String summary() {
            return "indices " + this.indices;
        }

        public List<String> indices() {
            return this.indices;
        }

        public String getWriteableName() {
            return FrozenExistenceDeciderService.NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.indices);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("indices", this.indices);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FrozenExistenceReason that = (FrozenExistenceReason)o;
            return this.indices.equals(that.indices);
        }

        public int hashCode() {
            return Objects.hash(this.indices);
        }
    }
}

