/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.rule.ParameterizedRule;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.InvalidMappedField;
import org.elasticsearch.xpack.ql.type.UnsupportedEsField;

public final class AnalyzerRules {
    public static Function resolveFunction(UnresolvedFunction uf, Configuration configuration, FunctionRegistry functionRegistry) {
        Function f = null;
        if (uf.analyzed()) {
            f = uf;
        } else if (!uf.childrenResolved()) {
            f = uf;
        } else {
            String functionName = functionRegistry.resolveAlias(uf.name());
            if (!functionRegistry.functionExists(functionName)) {
                f = uf.missing(functionName, functionRegistry.listFunctions());
            } else {
                FunctionDefinition def = functionRegistry.resolveFunction(functionName);
                f = uf.buildResolved(configuration, def);
            }
        }
        return f;
    }

    public static List<Attribute> maybeResolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList, boolean allowCompound, boolean acceptPattern, BiFunction<UnresolvedAttribute, Attribute, Attribute> specialFieldHandler) {
        ArrayList<Attribute> matches = new ArrayList<Attribute>();
        boolean qualified = u.qualifier() != null;
        String name = u.name();
        boolean isPattern = acceptPattern && Regex.isSimpleMatchPattern((String)name);
        BiFunction<String, String, Boolean> nameMatcher = isPattern ? Regex::simpleMatch : Objects::equals;
        for (Attribute attribute : attrList) {
            boolean match;
            if (attribute.synthetic() || !(match = qualified ? Objects.equals(u.qualifiedName(), attribute.qualifiedName()) : nameMatcher.apply(name, attribute.name()) != false || nameMatcher.apply(name, attribute.qualifiedName()) != false)) continue;
            matches.add(attribute);
        }
        if (matches.isEmpty()) {
            return matches;
        }
        if (matches.size() == 1 || isPattern) {
            matches.replaceAll(e -> (Attribute)specialFieldHandler.apply(u, e.withLocation(u.source())));
            return matches;
        }
        List<String> refs = matches.stream().sorted((a, b) -> {
            int lineDiff = a.sourceLocation().getLineNumber() - b.sourceLocation().getLineNumber();
            int colDiff = a.sourceLocation().getColumnNumber() - b.sourceLocation().getColumnNumber();
            return lineDiff != 0 ? lineDiff : (colDiff != 0 ? colDiff : a.qualifiedName().compareTo(b.qualifiedName()));
        }).map(a -> "line " + a.sourceLocation().toString().substring(1) + " [" + (String)(a.qualifier() != null ? "\"" + a.qualifier() + "\".\"" + a.name() + "\"" : a.name()) + "]").toList();
        return Collections.singletonList(u.withUnresolvedMessage("Reference [" + u.qualifiedName() + "] is ambiguous (to disambiguate use quotes or qualifiers); matches any of " + refs));
    }

    public static Attribute handleSpecialFields(UnresolvedAttribute u, Attribute named, boolean allowCompound) {
        if (named instanceof FieldAttribute) {
            FieldAttribute fa = (FieldAttribute)named;
            if (fa.field() instanceof InvalidMappedField) {
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] due to ambiguities being " + ((InvalidMappedField)fa.field()).errorMessage());
            } else if (DataTypes.isUnsupported(fa.dataType())) {
                UnsupportedEsField unsupportedField = (UnsupportedEsField)fa.field();
                named = unsupportedField.hasInherited() ? u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] with unsupported type [" + unsupportedField.getOriginalType() + "] in hierarchy (field [" + unsupportedField.getInherited() + "])") : u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] with unsupported type [" + unsupportedField.getOriginalType() + "]");
            } else if (!allowCompound && !DataTypes.isPrimitive(fa.dataType())) {
                named = u.withUnresolvedMessage("Cannot use field [" + fa.name() + "] type [" + fa.dataType().typeName() + "] only its subfields");
            }
        }
        return named;
    }

    public static abstract class BaseAnalyzerRule
    extends AnalyzerRule<LogicalPlan> {
        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (!plan.childrenResolved()) {
                return plan;
            }
            return this.doRule(plan);
        }

        protected abstract LogicalPlan doRule(LogicalPlan var1);
    }

    public static abstract class ParameterizedAnalyzerRule<SubPlan extends LogicalPlan, P>
    extends ParameterizedRule<SubPlan, LogicalPlan, P> {
        @Override
        public final LogicalPlan apply(LogicalPlan plan, P context) {
            return plan.transformUp(this.typeToken(), t -> t.analyzed() || this.skipResolved() && t.resolved() ? t : this.rule(t, context));
        }

        protected abstract LogicalPlan rule(SubPlan var1, P var2);

        protected boolean skipResolved() {
            return true;
        }
    }

    public static abstract class AnalyzerRule<SubPlan extends LogicalPlan>
    extends Rule<SubPlan, LogicalPlan> {
        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return plan.transformUp(this.typeToken(), t -> t.analyzed() || this.skipResolved() && t.resolved() ? t : this.rule(t));
        }

        protected abstract LogicalPlan rule(SubPlan var1);

        protected boolean skipResolved() {
            return true;
        }
    }

    public static class AddMissingEqualsToBoolField
    extends AnalyzerRule<Filter> {
        @Override
        protected LogicalPlan rule(Filter filter) {
            if (!filter.resolved()) {
                return filter;
            }
            Expression condition = AddMissingEqualsToBoolField.replaceRawBoolFieldWithEquals(filter.condition());
            if (condition == filter.condition()) {
                condition = condition.transformUp(BinaryLogic.class, b -> b.replaceChildren((List)Arrays.asList(AddMissingEqualsToBoolField.replaceRawBoolFieldWithEquals(b.left()), AddMissingEqualsToBoolField.replaceRawBoolFieldWithEquals(b.right()))));
            }
            if (condition != filter.condition()) {
                filter = filter.with(condition);
            }
            return filter;
        }

        private static Expression replaceRawBoolFieldWithEquals(Expression e) {
            if (e instanceof FieldAttribute && e.dataType() == DataTypes.BOOLEAN) {
                e = new Equals(e.source(), e, Literal.of(e, Boolean.TRUE));
            }
            return e;
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }
    }
}

